/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause;

import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils2;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractWhereClausePart
implements IWhereClausePart {
    private String whereClause;
    private String column;

    protected AbstractWhereClausePart(ColumnDisplayDefinition columnDef, String whereClausePart) {
        this.setColumn(DialectUtils2.checkColumnDoubleQuotes(columnDef.getDialectType(), columnDef.getColumnName()));
        this.setWhereClause(whereClausePart);
    }

    protected AbstractWhereClausePart(ColumnDisplayDefinition columnDef) {
        if (columnDef == null) {
            throw new IllegalArgumentException("columnDef must not be null");
        }
        this.setColumn(DialectUtils2.checkColumnDoubleQuotes(columnDef.getDialectType(), columnDef.getColumnName()));
    }

    private void setColumn(String column) {
        if (StringUtils.isEmpty((CharSequence)column)) {
            throw new IllegalArgumentException("column must be not empty");
        }
        this.column = column;
    }

    @Override
    public String getWhereClause() {
        if (this.whereClause == null) {
            throw new IllegalStateException("It's not intended, that an part of an where-clause is null!");
        }
        return this.whereClause;
    }

    @Override
    public void appendToClause(StringBuilder whereClause) {
        if (!this.shouldBeUsed()) {
            throw new IllegalStateException("Should append to a whereClause, but this one should not be used!");
        }
        String clause = this.getWhereClause();
        if (whereClause.length() == 0) {
            whereClause.append(" WHERE ");
            whereClause.append(clause);
        } else {
            whereClause.append(" AND ");
            whereClause.append(clause);
        }
    }

    protected void setWhereClause(String clause) {
        if (StringUtils.isBlank((CharSequence)clause)) {
            throw new IllegalArgumentException("clause must not be blank.");
        }
        this.whereClause = clause;
    }

    @Override
    public boolean shouldBeUsed() {
        return true;
    }

    @Override
    public Object getParamValue() {
        return "<has no value>";
    }

    public String getColumn() {
        return this.column;
    }
}

