/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataUpdateInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.PopupEditableIOPanel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CellDataColumnDataPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CellDataColumnDataPanel.class);
    private final PopupEditableIOPanel _ioPanel;
    private CellDataUpdateInfo _cellDataUpdateInfo;

    public CellDataColumnDataPanel(Object cellContents, ColumnDisplayDefinition colDef, boolean tableIsEditable) {
        super(new BorderLayout());
        if (tableIsEditable && CellComponentFactory.isEditableInPopup(colDef, cellContents)) {
            this._ioPanel = new PopupEditableIOPanel(colDef, cellContents, true);
            JPanel editingControls = this.createPopupEditingControls();
            this.add((Component)editingControls, "South");
        } else {
            this._ioPanel = new PopupEditableIOPanel(colDef, cellContents, false);
        }
        this.add((Component)this._ioPanel, "Center");
    }

    private JPanel createPopupEditingControls() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel updateControls = new JPanel();
        JButton updateButton = new JButton(s_stringMgr.getString("cellDataPopUp.updateData"));
        updateButton.addActionListener(event -> this.onUpdate());
        JButton cancelButton = new JButton(s_stringMgr.getString("cellDataPopup.cancel"));
        cancelButton.addActionListener(event -> this.onCancel());
        updateControls.add(updateButton);
        updateControls.add(cancelButton);
        panel.add((Component)updateControls, "South");
        return panel;
    }

    private void onCancel() {
        this._cellDataUpdateInfo.closeParentDialog();
    }

    private void onUpdate() {
        StringBuffer messageBuffer = new StringBuffer();
        Object newValue = this._ioPanel.getObject(messageBuffer);
        if (messageBuffer.length() > 0) {
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("cellDataPopUp.cannnotBGeConverted", messageBuffer), s_stringMgr.getString("cellDataPopUp.conversionError"), 0);
            this._ioPanel.requestFocus();
        } else {
            if (null != this._cellDataUpdateInfo.getTable().getCellEditor()) {
                this._cellDataUpdateInfo.getTable().getCellEditor().cancelCellEditing();
            }
            this._cellDataUpdateInfo.getTable().setValueAt(newValue, this._cellDataUpdateInfo.getRow(), this._cellDataUpdateInfo.getCol());
            this._cellDataUpdateInfo.closeParentDialog();
            this._cellDataUpdateInfo.getTable().repaint();
        }
    }

    public void setCellDataUpdateInfo(CellDataUpdateInfo cellDataUpdateInfo) {
        this._cellDataUpdateInfo = cellDataUpdateInfo;
    }
}

