/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataDialog;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CellDataPopup {
    public static final String PREF_KEY_POPUPEDITABLEIOPANEL_WIDTH = "Squirrel.popupEditableIOPanelWidth";
    public static final String PREF_KEY_POPUPEDITABLEIOPANEL_HEIGHT = "Squirrel.popupEditableIOPanelHeight";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CellDataPopup.class);

    public static void showDialog(JTable table, ColumnDisplayDefinition colDef, MouseEvent evt, boolean isModelEditable) {
        CellDataPopup popup = new CellDataPopup();
        popup.createAndShowDialog(table, evt, colDef, isModelEditable);
    }

    private void createAndShowDialog(JTable table, MouseEvent evt, ColumnDisplayDefinition colDef, boolean isModelEditable) {
        Dimension dim;
        Point pt = evt.getPoint();
        int row = table.rowAtPoint(pt);
        int col = table.columnAtPoint(pt);
        Object obj = table.getValueAt(row, col);
        TableCellEditor editor = table.getCellEditor(row, col);
        if (editor != null) {
            editor.cancelCellEditing();
        }
        Window parent = SwingUtilities.windowForComponent(table);
        final CellDataDialog dialog = new CellDataDialog(table, table.getColumnName(col), colDef, obj, row, col, isModelEditable, table);
        dialog.pack();
        if (Main.getApplication().getSquirrelPreferences().isRememberValueOfPopup()) {
            int width = Props.getInt(PREF_KEY_POPUPEDITABLEIOPANEL_WIDTH, 600);
            int height = Props.getInt(PREF_KEY_POPUPEDITABLEIOPANEL_HEIGHT, 300);
            dim = new Dimension(width, height);
        } else {
            dim = dialog.getSize();
            if (dim.width < 300) {
                dim.width = 300;
            }
            if (dim.height < 300) {
                dim.height = 300;
            }
            if (dim.width > 600) {
                dim.width = 600;
            }
            if (dim.height > 500) {
                dim.height = 500;
            }
        }
        Point dialogPos = parent.getLocation();
        dialogPos.x += SwingUtilities.convertPoint((Component)((Component)evt.getSource()), (Point)pt, (Component)parent).x;
        dialogPos.y += SwingUtilities.convertPoint((Component)((Component)evt.getSource()), (Point)pt, (Component)parent).y;
        Rectangle dialogRect = GUIUtils.ensureBoundsOnOneScreen(new Rectangle(dialogPos.x, dialogPos.y, dim.width, dim.height));
        dialog.setBounds(dialogRect);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Props.putInt(CellDataPopup.PREF_KEY_POPUPEDITABLEIOPANEL_WIDTH, dialog.getSize().width);
                Props.putInt(CellDataPopup.PREF_KEY_POPUPEDITABLEIOPANEL_HEIGHT, dialog.getSize().height);
            }
        });
        dialog.setVisible(true);
    }
}

