/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class CellDataPopupFormatter {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CellDataPopupFormatter.class);
    private static final ILogger s_log = LoggerController.createLogger(CellDataPopupFormatter.class);

    public static String format(String toFormat) {
        Exception jsonFormatException = null;
        FormatResult formatResult = CellDataPopupFormatter.tryJson(toFormat);
        jsonFormatException = formatResult.error;
        if (null == jsonFormatException) {
            return formatResult.result;
        }
        formatResult = CellDataPopupFormatter.tryXml(toFormat);
        if (null == formatResult.error) {
            return formatResult.result;
        }
        String msg = s_stringMgr.getString("CellDataPopupFormatter.failed.reformat", StringUtilities.removeNewLine("" + jsonFormatException), StringUtilities.removeNewLine("" + formatResult.error));
        Main.getApplication().getMessageHandler().showErrorMessage(msg);
        s_log.error("Failed to reformat cell data as JSON and as XML.\nJSON error:\n" + Utilities.getStackTrace(jsonFormatException) + "XML error:\n" + Utilities.getStackTrace(formatResult.error));
        return toFormat;
    }

    private static FormatResult tryXml(String toFormat) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(toFormat)));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 3);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            if (null == document.getXmlEncoding() && !document.getXmlStandalone()) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            String formatted = writer.toString();
            formatted = StringUtilities.removeEmptyLines(formatted, previousLine -> false == previousLine.trim().endsWith(">"));
            return new FormatResult(formatted);
        }
        catch (Exception e) {
            return new FormatResult(e);
        }
    }

    private static FormatResult tryJson(String toFormat) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(toFormat);
            StringWriter sw = new StringWriter();
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)sw, (Object)jsonNode);
            return new FormatResult(sw.toString());
        }
        catch (IOException e) {
            return new FormatResult(e);
        }
    }

    public static void main(String[] args) {
        String json = "[             {                                     \"url\" : \"jdbc:derby://<server>[:<port>]/<databaseName>[;<URL attribute>=<value>]\",   \"squirrelPredefinedDriver\" :                       true,   \"websiteUrl\" : \"http://db.apache.org/derby\",   \"jarFileNamesList\" : [ ],   \"driverClassName\" :                                \"org.apache.derby.jdbc.ClientDriver\",   \"name\" : \"Apache Derby Client\",   \"id\" : \"PRE_DEF_0042\" }, {   \"url\" : \"jdbc:derby:<database>[;create=true]\",   \"squirrelPredefinedDriver\" : true,   \"websiteUrl\" : \"http://db.apache.org/derby\",   \"jarFileNamesList\" : [ ],   \"driverClassName\" : \"org.apache.derby.jdbc.EmbeddedDriver\",   \"name\" : \"Apache Derby Embedded\",   \"id\" : \"PRE_DEF_0041\" }]";
        System.out.println("1: " + CellDataPopupFormatter.tryJson((String)json).result);
        System.out.println("2: " + CellDataPopupFormatter.tryJson((String)" ").result);
        System.out.println("3: " + CellDataPopupFormatter.tryJson((String)" ffg").result);
        System.out.println("4: " + CellDataPopupFormatter.tryJson((String)"122").result);
        String jsonCut = "[             {                                     \"url\" : \"jdbc:derby://<server>[:<port>]/<databaseName>[;<URL attribute>=<value>]\",   \"squirrelPredefinedDriver\" :                       true,   \"websiteUrl\" : \"http://db.apache.org/derby\",   \"jarFileNamesList\" : [ ],   \"driverClassName\" :                                \"org.apache.derby.jdbc.ClientDriver\",   \"name\" : \"Apache Derby Client\",   \"id\" : \"PRE_DEF_0042\" }, {   \"url\" : \"jdbc:derby:<database>[;create=true]\",   \"squirrelPredefinedDriver\" : true, ";
        System.out.println("4: " + CellDataPopupFormatter.tryJson((String)jsonCut).result);
        System.out.println("5: " + CellDataPopupFormatter.tryXml((String)"<AU> <someTag>bla</someTag> <otherTag>blub</otherTag> </AU>").result);
        String xml = "<emails> <email> <from>Kai</from> <to>Amanda</to> <time>2018-03-05</time>\n<subject>I am flying to you</subject></email> <email>\n<from>Jerry</from> <to>Tom</to> <time>1992-08-08</time> <subject>Hey Tom, catch me if you can!</subject>\n</email> </emails>";
        System.out.println("6: " + CellDataPopupFormatter.tryXml((String)xml).result);
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<users>\n<user>\n<name>test one</name>\n<last-name>test two</last-name>\n<username>test three</username>\n</user>\n</users>\n";
        System.out.println("7: " + CellDataPopupFormatter.tryXml((String)xml).result);
        System.out.println("8: " + CellDataPopupFormatter.tryXml((String)"<AU> <someTag>bla</someTag> dgfdg\nsdsdfds <otherTag>blub</otherTag> </AU>").result);
    }

    private static class FormatResult {
        private String result;
        private Exception error;

        public FormatResult(String result) {
            this.result = result;
        }

        public FormatResult(Exception error) {
            this.error = error;
        }
    }
}

