/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.DBDIffService;
import net.sourceforge.squirrel_sql.client.session.action.dbdiff.tableselectiondiff.TableSelectionDiffUtil;
import net.sourceforge.squirrel_sql.client.session.mainpanel.multiclipboard.PasteFromHistoryAttach;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BinaryDisplayConverter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopupFormatter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellImportExportInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellImportExportInfoSaver;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.FileResult;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.EditableComboBoxHandler;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.textfind.TextFindCtrl;
import net.sourceforge.squirrel_sql.fw.util.DesktopUtil;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class PopupEditableIOPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PopupEditableIOPanel.class);
    public static final String ACTION_BROWSE = "browse";
    public static final String ACTION_EXPORT = "export";
    public static final String ACTION_REFORMAT = "reformat";
    public static final String ACTION_FIND = "find";
    public static final String ACTION_EXECUTE = "execute";
    public static final String ACTION_APPLY = "apply";
    public static final String ACTION_IMPORT = "import";
    private final JTextArea _textArea;
    private final JScrollPane _scrollPane;
    private final TextFindCtrl _textFindCtrl;
    private final ColumnDisplayDefinition _colDef;
    private final JCheckBoxMenuItem _chkMnuLineWrap;
    private final JCheckBoxMenuItem _chkMnuWordWrap;
    private MouseAdapter _lis;
    private final TextPopupMenu _popupMenu;
    private EditableComboBoxHandler cboFileNameHandler;
    private JComboBox externalCommandCombo;
    private Object originalValue;
    private JComboBox radixList = null;
    private String previousRadixListItem = null;
    private JCheckBox showAscii = null;
    private boolean previousShowAscii;
    private IOUtilities _iou = new IOUtilitiesImpl();
    private transient BinaryOptionActionListener optionActionListener = new BinaryOptionActionListener();
    private final String TEMP_FILE_FLAG = "<temp file>";
    private final String FILE_REPLACE_FLAG = "%f";

    public PopupEditableIOPanel(ColumnDisplayDefinition colDef, Object value, boolean isEditable) {
        this.originalValue = value;
        this._popupMenu = new TextPopupMenu();
        this._colDef = colDef;
        this._textArea = CellComponentFactory.getJTextArea(colDef, value);
        if (isEditable) {
            this._textArea.setEditable(true);
            this._textArea.setBackground(SquirrelConstants.CELL_EDITABLE_COLOR);
        } else {
            this._textArea.setEditable(false);
        }
        this._textArea.setLineWrap(true);
        if (colDef.getSqlType() == 12 || colDef.getSqlType() == 2005 || colDef.getSqlType() == -16 || colDef.getSqlType() == -9 || colDef.getSqlType() == 2009) {
            this._textArea.setWrapStyleWord(true);
        }
        this.setLayout(new BorderLayout());
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BorderLayout());
        this._scrollPane = new JScrollPane(this._textArea);
        this._textFindCtrl = new TextFindCtrl(this._textArea, this._scrollPane);
        displayPanel.add((Component)this._textFindCtrl.getContainerPanel(), "Center");
        if (CellComponentFactory.useBinaryEditingPanel(colDef)) {
            String[] radixListData = new String[]{"Hex", "Decimal", "Octal", "Binary"};
            this.radixList = new JComboBox<String>(radixListData);
            this.radixList.addActionListener(this.optionActionListener);
            this.previousRadixListItem = "Hex";
            this.showAscii = new JCheckBox();
            this.previousShowAscii = false;
            this.showAscii.addActionListener(this.optionActionListener);
            JPanel displayControlsPanel = new JPanel();
            displayControlsPanel.add(new JLabel(s_stringMgr.getString("popupeditableIoPanel.numberBase")));
            displayControlsPanel.add(this.radixList);
            displayControlsPanel.add(new JLabel("    "));
            displayControlsPanel.add(this.showAscii);
            displayControlsPanel.add(new JLabel(s_stringMgr.getString("popupeditableIoPanel.showAscii")));
            displayPanel.add((Component)displayControlsPanel, "South");
        }
        this.add((Component)displayPanel, "Center");
        if (CellComponentFactory.canDoFileIO(colDef)) {
            this.add((Component)this.exportImportPanel(isEditable), "South");
        }
        this._chkMnuLineWrap = new JCheckBoxMenuItem(new LineWrapAction());
        this._chkMnuLineWrap.setSelected(this._textArea.getLineWrap());
        this._popupMenu.add(this._chkMnuLineWrap);
        this._chkMnuWordWrap = new JCheckBoxMenuItem(new WordWrapAction());
        this._chkMnuWordWrap.setSelected(this._textArea.getWrapStyleWord());
        this._popupMenu.add(this._chkMnuWordWrap);
        this._popupMenu.add(new XMLReformatAction());
        this._popupMenu.add(new CompareToClipAction()).setToolTipText(s_stringMgr.getString("popupEditableIoPanel.compare.to.clip.tooltip"));
        this._popupMenu.setTextComponent(this._textArea);
        new PasteFromHistoryAttach(this._textArea);
    }

    private JPanel exportImportPanel(boolean isEditable) {
        JPanel eiPanel = new JPanel();
        eiPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        eiPanel.add((Component)new JLabel(s_stringMgr.getString("popupeditableIoPanel.useFile")), gbc);
        gbc.fill = 2;
        gbc.weightx = 0.5;
        JComboBox cboFileName = new JComboBox();
        this.cboFileNameHandler = new EditableComboBoxHandler(cboFileName, this.getClass().getName() + ".cboFileName");
        this.cboFileNameHandler.selectFirstItemIfExists();
        Dimension preferredSize = cboFileName.getPreferredSize();
        cboFileName.setMinimumSize(new Dimension(preferredSize.width / 2, preferredSize.height));
        ++gbc.gridx;
        eiPanel.add(cboFileName, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JButton browseButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.browse"), Main.getApplication().getResources().getIcon("dir_obj"));
        browseButton.setToolTipText(s_stringMgr.getString("popupeditableIoPanel.browse.tooltip"));
        browseButton.setActionCommand(ACTION_BROWSE);
        browseButton.addActionListener(e -> this.onBrowse());
        ++gbc.gridx;
        eiPanel.add((Component)browseButton, gbc);
        JButton exportButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.export44"), Main.getApplication().getResources().getIcon("save"));
        exportButton.setToolTipText(s_stringMgr.getString("popupeditableIoPanel.export.tooltip"));
        exportButton.setActionCommand(ACTION_EXPORT);
        exportButton.addActionListener(e -> this.onActionPerformed(e));
        ++gbc.gridx;
        eiPanel.add((Component)exportButton, gbc);
        if (!isEditable) {
            this.addReformatButton(eiPanel, gbc);
            this.addFindButton(eiPanel, gbc);
            return eiPanel;
        }
        JButton importButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.import44"));
        importButton.setActionCommand(ACTION_IMPORT);
        importButton.addActionListener(e -> this.onActionPerformed(e));
        ++gbc.gridx;
        eiPanel.add((Component)importButton, gbc);
        this.addReformatButton(eiPanel, gbc);
        this.addFindButton(eiPanel, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        eiPanel.add((Component)new JLabel(s_stringMgr.getString("popupeditableIoPanel.withCommand")), gbc);
        ++gbc.gridx;
        this.externalCommandCombo = new JComboBox<String>(CellImportExportInfoSaver.getInstance().getCmdList());
        this.externalCommandCombo.setSelectedIndex(-1);
        this.externalCommandCombo.setEditable(true);
        this.externalCommandCombo.setPreferredSize(cboFileName.getPreferredSize());
        this.externalCommandCombo.setMinimumSize(cboFileName.getMinimumSize());
        gbc.fill = 2;
        gbc.weightx = 0.5;
        eiPanel.add((Component)this.externalCommandCombo, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JButton externalCommandButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.execute34"));
        externalCommandButton.setActionCommand(ACTION_EXECUTE);
        externalCommandButton.addActionListener(e -> this.onActionPerformed(e));
        ++gbc.gridx;
        eiPanel.add((Component)externalCommandButton, gbc);
        JButton applyButton = new JButton(s_stringMgr.getString("popupeditableIoPanel.applyFile"));
        applyButton.setActionCommand(ACTION_APPLY);
        applyButton.addActionListener(e -> this.onActionPerformed(e));
        ++gbc.gridx;
        gbc.gridwidth = 2;
        eiPanel.add((Component)applyButton, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        eiPanel.add((Component)new JLabel(s_stringMgr.getString("popupeditableIoPanel.replaceFile", "%f")), gbc);
        CellImportExportInfo info = CellImportExportInfoSaver.getInstance().get(this._colDef.getFullTableColumnName());
        if (info != null) {
            this.cboFileNameHandler.addOrReplaceCurrentItem(info.getFileName());
            this.externalCommandCombo.getEditor().setItem(info.getCommand());
        }
        return eiPanel;
    }

    private void addReformatButton(JPanel eiPanel, GridBagConstraints gbc) {
        JButton reformatButton = new JButton(s_stringMgr.getString("popupEditableIoPanel.reformatXml"));
        reformatButton.setActionCommand(ACTION_REFORMAT);
        reformatButton.addActionListener(e -> this.onActionPerformed(e));
        ++gbc.gridx;
        eiPanel.add((Component)reformatButton, gbc);
    }

    private void addFindButton(JPanel eiPanel, GridBagConstraints gbc) {
        JButton findButton = new JButton(Main.getApplication().getResources().getIcon(ACTION_FIND));
        findButton.setActionCommand(ACTION_FIND);
        findButton.addActionListener(e -> this.onActionPerformed(e));
        ++gbc.gridx;
        eiPanel.add((Component)findButton, gbc);
    }

    public Object getObject(StringBuffer messageBuffer) {
        try {
            String text = this.getTextAreaCannonicalForm();
            return CellComponentFactory.validateAndConvertInPopup(this._colDef, this.originalValue, text, messageBuffer);
        }
        catch (Exception e) {
            messageBuffer.append("Failed to convert binary text; error was:\n" + e.getMessage());
            return null;
        }
    }

    @Override
    public void requestFocus() {
        this._textArea.requestFocus();
    }

    private void onActionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(ACTION_APPLY)) {
            this.onActionApply();
        } else if (e.getActionCommand().equals(ACTION_IMPORT)) {
            this.onActionImport();
        } else if (e.getActionCommand().equals(ACTION_REFORMAT)) {
            this.reformat(GUIUtils.getOwningWindow(this));
        } else if (e.getActionCommand().equals(ACTION_FIND)) {
            this._textFindCtrl.toggleFind();
        } else {
            FileResult result = this.createFileResult();
            if (result == null) {
                return;
            }
            if (e.getActionCommand().equals(ACTION_EXPORT)) {
                this.onActionExport(result);
            } else if (e.getActionCommand().equals(ACTION_EXECUTE)) {
                this.onActionExecute(result);
            }
        }
    }

    private void onActionExecute(FileResult result) {
        FileOutputStream outStream = this.getFileOutputStream(result.file, result.canonicalFilePathName);
        if (outStream == null) {
            return;
        }
        this.onActionExecute(result.file, result.canonicalFilePathName, outStream);
    }

    private void onActionExport(FileResult result) {
        FileOutputStream outStream = this.getFileOutputStream(result.file, result.canonicalFilePathName);
        if (outStream == null) {
            return;
        }
        if (this.exportData(outStream, result.canonicalFilePathName)) {
            Object[] options = new Object[]{s_stringMgr.getString("popupeditableIoPanel.ok"), s_stringMgr.getString("popupeditableIoPanel.ok.open.in.file.manager")};
            int selectIndex = JOptionPane.showOptionDialog(this, s_stringMgr.getString("popupeditableIoPanel.exportedToFile", result.canonicalFilePathName), s_stringMgr.getString("popupeditableIoPanel.exportSuccess"), 0, 1, null, options, options[0]);
            if (1 == selectIndex) {
                DesktopUtil.openInFileManager(result.file);
            }
        }
    }

    private FileResult createFileResult() {
        String canonicalFilePathName = this.cboFileNameHandler.getItem();
        if (this.cboFileNameHandler.getItem() == null || this.cboFileNameHandler.getItem().equals("")) {
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.noExportFile"), s_stringMgr.getString("popupeditableIoPanel.exportError"), 0);
            return null;
        }
        File file = new File(this.cboFileNameHandler.getItem());
        try {
            canonicalFilePathName = file.getCanonicalPath();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.cannotAccessFile", this.cboFileNameHandler.getItem()), s_stringMgr.getString("popupeditableIoPanel.exportError3"), 0);
            return null;
        }
        if (file.exists()) {
            if (!file.isFile()) {
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.notANormalFile"), s_stringMgr.getString("popupeditableIoPanel.exportError4"), 0);
                return null;
            }
            if (!file.canWrite()) {
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.notWriteable"), s_stringMgr.getString("popupeditableIoPanel.exportError5"), 0);
                return null;
            }
            int option = JOptionPane.showConfirmDialog(this, s_stringMgr.getString("popupeditableIoPanel.fileOverwrite", canonicalFilePathName), s_stringMgr.getString("popupeditableIoPanel.overwriteWarning"), 0);
            if (option != 0) {
                return null;
            }
        } else {
            try {
                if (!PopupEditableIOPanel.createNewFileInclNeededDirs(file)) {
                    JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.createFileError", canonicalFilePathName), s_stringMgr.getString("popupeditableIoPanel.exportError6"), 0);
                    return null;
                }
            }
            catch (Exception ex) {
                Object[] args = new Object[]{canonicalFilePathName, ex.getMessage()};
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.cannotOpenFile", args), s_stringMgr.getString("popupeditableIoPanel.exportError7"), 0);
                return null;
            }
        }
        String extCmdComboItemStr = null;
        if (this.externalCommandCombo != null && this.externalCommandCombo.getEditor() != null) {
            extCmdComboItemStr = (String)this.externalCommandCombo.getEditor().getItem();
        }
        if (extCmdComboItemStr != null && extCmdComboItemStr.length() > 0) {
            String commandString = extCmdComboItemStr;
            CellImportExportInfoSaver.getInstance().save(this._colDef.getFullTableColumnName(), this.cboFileNameHandler.getItem(), commandString);
        }
        FileResult result = new FileResult(canonicalFilePathName, file);
        return result;
    }

    private static boolean createNewFileInclNeededDirs(File file) throws IOException {
        if (null != file.getParentFile()) {
            file.getParentFile().mkdirs();
        }
        return file.createNewFile();
    }

    private FileOutputStream getFileOutputStream(File file, String canonicalFilePathName) {
        FileOutputStream outStream;
        try {
            outStream = new FileOutputStream(file);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.cannotFindFile", canonicalFilePathName), s_stringMgr.getString("popupeditableIoPanel.exportError8"), 0);
            return null;
        }
        return outStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onActionExecute(File file, String canonicalFilePathName, FileOutputStream outStream) {
        int option;
        int commandResult;
        int index;
        if ((String)this.externalCommandCombo.getEditor().getItem() == null || ((String)this.externalCommandCombo.getEditor().getItem()).length() == 0) {
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.cannotExec"), s_stringMgr.getString("popupeditableIoPanel.executeError"), 0);
            return;
        }
        Object command = (String)this.externalCommandCombo.getEditor().getItem();
        while ((index = ((String)command).indexOf("%f")) >= 0) {
            command = ((String)command).substring(0, index) + canonicalFilePathName + ((String)command).substring(index + "%f".length());
        }
        if (!this.exportData(outStream, canonicalFilePathName)) {
            return;
        }
        BufferedReader err = null;
        try {
            Process cmdProcess = Runtime.getRuntime().exec((String)command);
            commandResult = cmdProcess.waitFor();
            err = new BufferedReader(new InputStreamReader(cmdProcess.getErrorStream()));
            String errMsg = err.readLine();
            if (errMsg != null) {
                throw new IOException("text on error stream from command starting with:\n" + errMsg);
            }
            this._iou.closeReader(err);
        }
        catch (Exception ex) {
            try {
                Object[] args = new Object[]{command, ex.getMessage()};
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.errWhileExecutin", args), s_stringMgr.getString("popupeditableIoPanel.executeError2"), 0);
                this._iou.closeReader(err);
                return;
            }
            catch (Throwable throwable) {
                this._iou.closeReader(err);
                throw throwable;
            }
        }
        if (commandResult != 0 && (option = JOptionPane.showConfirmDialog(this, s_stringMgr.getString("popupeditableIoPanel.commandReturnNot0", commandResult), s_stringMgr.getString("popupeditableIoPanel.importWarning"), 0)) != 0) {
            return;
        }
        this.importData(file);
        file.delete();
    }

    private void onActionImport() {
        if (StringUtilities.isEmpty(this.cboFileNameHandler.getItem(), true)) {
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.selectImportDataFile"), s_stringMgr.getString("popupeditableIoPanel.noFile"), 0);
            return;
        }
        File file = new File(this.cboFileNameHandler.getItem());
        if (!(file.exists() && file.isFile() && file.canRead())) {
            String msg = s_stringMgr.getString("popupeditableIoPanel.fileDoesNotExist", this.cboFileNameHandler.getItem());
            JOptionPane.showMessageDialog(this, msg, s_stringMgr.getString("popupeditableIoPanel.fileError"), 0);
            return;
        }
        this.importData(file);
        CellImportExportInfoSaver.getInstance().save(this._colDef.getFullTableColumnName(), this.cboFileNameHandler.getItem(), (String)this.externalCommandCombo.getEditor().getItem());
    }

    private void onActionApply() {
        if (this.cboFileNameHandler.getItem() != null && (this.externalCommandCombo.getEditor().getItem() == null || ((String)this.externalCommandCombo.getEditor().getItem()).length() == 0)) {
            CellImportExportInfoSaver.remove(this._colDef.getFullTableColumnName());
        } else {
            CellImportExportInfoSaver.getInstance().save(this._colDef.getFullTableColumnName(), this.cboFileNameHandler.getItem(), (String)this.externalCommandCombo.getEditor().getItem());
        }
    }

    private void onBrowse() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        if (!StringUtilities.isEmpty(this.cboFileNameHandler.getItem(), true)) {
            File f = new File(this.cboFileNameHandler.getItem());
            chooser.setCurrentDirectory(f);
        }
        if ((returnVal = chooser.showSaveDialog(this)) == 0) {
            try {
                this.cboFileNameHandler.addOrReplaceCurrentItem(chooser.getSelectedFile().getCanonicalPath());
                this.cboFileNameHandler.saveCurrentItem();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.errorGettingPath"), s_stringMgr.getString("popupeditableIoPanel.fileChooserError"), 0);
            }
        }
    }

    private void importData(File file) {
        FileInputStream inStream;
        String canonicalFilePathName = this.cboFileNameHandler.getItem();
        try {
            inStream = new FileInputStream(file);
            canonicalFilePathName = file.getCanonicalPath();
        }
        catch (Exception ex) {
            Object[] args = new Object[]{canonicalFilePathName, ex.getMessage()};
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.fileOpenError", args), s_stringMgr.getString("popupeditableIoPanel.fileOpenErrorHeader"), 0);
            return;
        }
        try {
            String replacementText = CellComponentFactory.importObject(this._colDef, inStream);
            if (this.radixList != null && (!this.radixList.getSelectedItem().equals("Hex") || this.showAscii.isSelected())) {
                int base = 16;
                if (this.radixList.getSelectedItem().equals("Decimal")) {
                    base = 10;
                } else if (this.radixList.getSelectedItem().equals("Octal")) {
                    base = 8;
                } else if (this.radixList.getSelectedItem().equals("Binary")) {
                    base = 2;
                }
                Byte[] bytes = BinaryDisplayConverter.convertToBytes(replacementText, 16, false);
                replacementText = BinaryDisplayConverter.convertToString(bytes, base, this.showAscii.isSelected());
            }
            ((RestorableJTextArea)this._textArea).updateText(replacementText);
        }
        catch (Exception ex) {
            Object[] args = new Object[]{canonicalFilePathName, ex.getMessage()};
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.errorReadingFile", args), s_stringMgr.getString("popupeditableIoPanel.importError2"), 0);
            return;
        }
        try {
            inStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean exportData(FileOutputStream outStream, String canonicalFilePathName) {
        try {
            CellComponentFactory.exportObject(this._colDef, outStream, this.getTextAreaCannonicalForm());
            this.cboFileNameHandler.saveCurrentItem();
        }
        catch (Exception ex) {
            Object[] args = new Object[]{canonicalFilePathName, ex.getMessage()};
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("popupeditableIoPanel.errorWritingFile", args), s_stringMgr.getString("popupeditableIoPanel.exportError100"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._lis == null) {
            this._lis = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        PopupEditableIOPanel.this._popupMenu.show(evt);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        PopupEditableIOPanel.this._popupMenu.show(evt);
                    }
                }
            };
            this._textArea.addMouseListener(this._lis);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._lis != null) {
            this._textArea.removeMouseListener(this._lis);
            this._lis = null;
        }
    }

    private void lineWrapWordWrapChanged(boolean wordWrapChanged) {
        if (wordWrapChanged) {
            this._textArea.setWrapStyleWord(!this._textArea.getWrapStyleWord());
            if (this._textArea.getWrapStyleWord()) {
                this._textArea.setLineWrap(true);
            }
        } else {
            this._textArea.setLineWrap(!this._textArea.getLineWrap());
            if (this._textArea.getWrapStyleWord()) {
                this._textArea.setWrapStyleWord(false);
            }
        }
        this._chkMnuLineWrap.setSelected(this._textArea.getLineWrap());
        this._chkMnuWordWrap.setSelected(this._textArea.getWrapStyleWord());
    }

    private void compareToClip() {
        String clipboardAsString = ClipboardUtil.getClipboardAsString();
        if (StringUtilities.isEmpty(clipboardAsString, true)) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("popupEditableIoPanel.clipboard.empty.warn"));
            return;
        }
        String cellText = this._textArea.getSelectedText();
        if (StringUtilities.isEmpty(cellText, true)) {
            cellText = this._textArea.getText();
        }
        if (StringUtilities.isEmpty(cellText, true)) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("popupEditableIoPanel.cell.empty.warn"));
            return;
        }
        Path leftClipboardTempFile = TableSelectionDiffUtil.createLeftTempFile(clipboardAsString);
        Path rightCellTextTempFile = TableSelectionDiffUtil.createRightTempFile(cellText);
        String title = s_stringMgr.getString("popupEditableIoPanel.clipboard.vs.cell.data");
        DBDIffService.showDiff(leftClipboardTempFile, rightCellTextTempFile, title, GUIUtils.getOwningWindow(this._textArea));
    }

    private void reformat(Window owningWindow) {
        this._textArea.setText(CellDataPopupFormatter.format(this._textArea.getText()));
    }

    private String getTextAreaCannonicalForm() {
        if (this._textArea.getText() == null || this._textArea.getText().equals("<null>") || this._textArea.getText().length() == 0) {
            return this._textArea.getText();
        }
        if (this.radixList == null || this.radixList.getSelectedItem().equals("Hex") && !this.showAscii.isSelected()) {
            return this._textArea.getText();
        }
        int base = 16;
        if (this.radixList.getSelectedItem().equals("Decimal")) {
            base = 10;
        } else if (this.radixList.getSelectedItem().equals("Octal")) {
            base = 8;
        } else if (this.radixList.getSelectedItem().equals("Binary")) {
            base = 2;
        }
        Byte[] bytes = BinaryDisplayConverter.convertToBytes(this._textArea.getText(), base, this.showAscii.isSelected());
        return BinaryDisplayConverter.convertToString(bytes, 16, false);
    }

    private class CompareToClipAction
    extends BaseAction {
        CompareToClipAction() {
            super(s_stringMgr.getString("popupEditableIoPanel.compare.to.clip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PopupEditableIOPanel.this.compareToClip();
        }
    }

    private class XMLReformatAction
    extends BaseAction {
        XMLReformatAction() {
            super(s_stringMgr.getString("popupEditableIoPanel.reformatXml"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PopupEditableIOPanel.this.reformat(GUIUtils.getOwningWindow(PopupEditableIOPanel.this));
        }
    }

    private class WordWrapAction
    extends BaseAction {
        WordWrapAction() {
            super(s_stringMgr.getString("popupEditableIoPanel.wrapWord"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (PopupEditableIOPanel.this._textArea != null) {
                PopupEditableIOPanel.this.lineWrapWordWrapChanged(true);
            }
        }
    }

    private class LineWrapAction
    extends BaseAction {
        LineWrapAction() {
            super(s_stringMgr.getString("popupEditableIoPanel.wrapLines"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (PopupEditableIOPanel.this._textArea != null) {
                PopupEditableIOPanel.this.lineWrapWordWrapChanged(false);
            }
        }
    }

    class BinaryOptionActionListener
    implements ActionListener {
        BinaryOptionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int base = 16;
            if (PopupEditableIOPanel.this.previousRadixListItem.equals("Decimal")) {
                base = 10;
            } else if (PopupEditableIOPanel.this.previousRadixListItem.equals("Octal")) {
                base = 8;
            } else if (PopupEditableIOPanel.this.previousRadixListItem.equals("Binary")) {
                base = 2;
            }
            Byte[] bytes = BinaryDisplayConverter.convertToBytes(PopupEditableIOPanel.this._textArea.getText(), base, PopupEditableIOPanel.this.previousShowAscii);
            base = 16;
            if (PopupEditableIOPanel.this.radixList.getSelectedItem().equals("Decimal")) {
                base = 10;
            } else if (PopupEditableIOPanel.this.radixList.getSelectedItem().equals("Octal")) {
                base = 8;
            } else if (PopupEditableIOPanel.this.radixList.getSelectedItem().equals("Binary")) {
                base = 2;
            }
            ((RestorableJTextArea)PopupEditableIOPanel.this._textArea).updateText(BinaryDisplayConverter.convertToString(bytes, base, PopupEditableIOPanel.this.showAscii.isSelected()));
            PopupEditableIOPanel.this.previousRadixListItem = (String)PopupEditableIOPanel.this.radixList.getSelectedItem();
            PopupEditableIOPanel.this.previousShowAscii = PopupEditableIOPanel.this.showAscii.isSelected();
        }
    }
}

