/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring;

import java.awt.Color;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.ColoringCallback;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.NullValueColorHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.UserColorHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindColorHandler;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;

public class ColoringService {
    private UserColorHandler _userColorHandler;
    private DataSetViewerTable _dataSetViewerTable;
    private FindColorHandler _findColorHandler;
    private MarkDuplicatesHandler _markDuplicatesHandler;
    private NullValueColorHandler _nullValueColorHandler;
    private ColoringCallback _coloringCallback;

    public ColoringService(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
        this._userColorHandler = new UserColorHandler(dataSetViewerTable);
        this._findColorHandler = new FindColorHandler();
        this._markDuplicatesHandler = new MarkDuplicatesHandler(dataSetViewerTable);
        this._nullValueColorHandler = new NullValueColorHandler(this._dataSetViewerTable);
    }

    public void colorCell(CellRenderer cellRenderer, IDataTypeComponent dataTypeObject, JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIx, int columnIx) {
        Color buf;
        Color findBackground;
        Color markDuplicateBackground;
        if (-42 == table.getColumnModel().getColumn(columnIx).getModelIndex()) {
            return;
        }
        Color customBackground = null;
        if (dataTypeObject != null && !dataTypeObject.isEditableInCell(value) && dataTypeObject.isEditableInPopup(value)) {
            customBackground = SquirrelConstants.MULTI_LINE_CELL_COLOR;
        } else if (null == value && !isSelected && this._nullValueColorHandler.isColorNullValues()) {
            customBackground = this._nullValueColorHandler.getNullValueColor();
        }
        Color userColor = this._userColorHandler.getBackground(columnIx, rowIx, isSelected);
        if (null != userColor) {
            customBackground = userColor;
        }
        if (null != (markDuplicateBackground = this._markDuplicatesHandler.getBackgroundForCell(rowIx, columnIx, value))) {
            customBackground = markDuplicateBackground;
        }
        if (null != (findBackground = this._findColorHandler.getBackgroundForCell(rowIx, columnIx))) {
            customBackground = findBackground;
        }
        if (null != this._coloringCallback && null != (buf = this._coloringCallback.getCellColor(rowIx, columnIx, isSelected))) {
            customBackground = buf;
        }
        if (null != customBackground) {
            cellRenderer.setBackground(customBackground);
        } else if (isSelected) {
            cellRenderer.setBackground(this._dataSetViewerTable.getSelectionBackground());
        } else {
            cellRenderer.setBackground(this._dataSetViewerTable.getBackground());
        }
    }

    public UserColorHandler getUserColorHandler() {
        return this._userColorHandler;
    }

    public FindColorHandler getFindColorHandler() {
        return this._findColorHandler;
    }

    public MarkDuplicatesHandler getMarkDuplicatesHandler() {
        return this._markDuplicatesHandler;
    }

    public void setColoringCallback(ColoringCallback coloringCallback) {
        this._coloringCallback = coloringCallback;
    }

    public Color getExcelExportRelevantColor(int rowIx, int columnIx, Object cellValue) {
        Color findBackground;
        Color markDuplicateBackground;
        Color customBackground = null;
        Color userColor = this._userColorHandler.getBackground(columnIx, rowIx, false);
        if (null != userColor) {
            customBackground = userColor;
        }
        if (null != (markDuplicateBackground = this._markDuplicatesHandler.getBackgroundForCell(rowIx, columnIx, cellValue))) {
            customBackground = markDuplicateBackground;
        }
        if (null != (findBackground = this._findColorHandler.getBackgroundForCell(rowIx, columnIx))) {
            customBackground = findBackground;
        }
        return customBackground;
    }
}

