/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;

public class NullValueColorHandler {
    private boolean _colorNullValues;
    private DataSetViewerTable _dataSetViewerTable;
    private Color _nullValueColor;

    public NullValueColorHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
        ISession session = this._dataSetViewerTable.getSessionOrNull();
        if (null == session) {
            SessionProperties newSessionProperties = Main.getApplication().getSquirrelPreferences().getSessionProperties();
            this._nullValueColor = new Color(newSessionProperties.getNullValueColorRGB());
            this._colorNullValues = newSessionProperties.isColorNullValues();
        } else {
            this._nullValueColor = new Color(session.getProperties().getNullValueColorRGB());
            this._colorNullValues = session.getProperties().isColorNullValues();
            session.getProperties().addPropertyChangeListener(evt -> this.onPropertyChange(evt));
        }
    }

    private void onPropertyChange(PropertyChangeEvent evt) {
        if ("colorNullValues".equals(evt.getPropertyName()) || "nullValueColorRGB".equals(evt.getPropertyName())) {
            this._nullValueColor = new Color(this._dataSetViewerTable.getSessionOrNull().getProperties().getNullValueColorRGB());
            this._colorNullValues = this._dataSetViewerTable.getSessionOrNull().getProperties().isColorNullValues();
            this._dataSetViewerTable.repaint();
        }
    }

    public Color getNullValueColor() {
        return this._nullValueColor;
    }

    public boolean isColorNullValues() {
        return this._colorNullValues;
    }
}

