/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring;

import java.awt.Color;
import java.awt.Point;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.RowColorHandlerState;
import net.sourceforge.squirrel_sql.fw.gui.action.colorrows.ColorSelectionType;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class UserColorHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private HashMap<Integer, Color> _colorByRow = new HashMap();
    private HashMap<Point, Color> _colorByCell = new HashMap();
    private Point _readBufferPoint = new Point();

    public UserColorHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
    }

    public Color getFirstColorInSelection() {
        for (int row : this._dataSetViewerTable.getSelectedRows()) {
            int modelRow = this._dataSetViewerTable.getSortableTableModel().transformToModelRow(row);
            if (null != this._colorByRow.get(modelRow)) {
                return this._colorByRow.get(modelRow);
            }
            int[] nArray = this._dataSetViewerTable.getSelectedColumns();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int col;
                this._readBufferPoint.x = col = nArray[i];
                this._readBufferPoint.y = modelRow;
                if (null == this._colorByCell.get(this._readBufferPoint)) continue;
                return this._colorByCell.get(this._readBufferPoint);
            }
        }
        return null;
    }

    public void setColorForSelection(Color newColor, ColorSelectionType selectionType) {
        switch (selectionType) {
            case ROWS: {
                this.setColorForSelectedRows(newColor);
                break;
            }
            case CELLS: {
                this.setColorForSelectedCells(newColor);
            }
        }
    }

    public void setColorForSelectedRows(Color newColor) {
        for (int viewRow : this._dataSetViewerTable.getSelectedRows()) {
            int modelRow = this._dataSetViewerTable.getSortableTableModel().transformToModelRow(viewRow);
            for (int col = 0; col < this._dataSetViewerTable.getColumnCount(); ++col) {
                this._colorByCell.remove(new Point(col, modelRow));
            }
            if (null == newColor) {
                this._colorByRow.remove(modelRow);
                continue;
            }
            this._colorByRow.put(modelRow, newColor);
        }
        this._dataSetViewerTable.repaint();
    }

    public void setColorForSelectedCells(Color newColor) {
        for (int viewRow : this._dataSetViewerTable.getSelectedRows()) {
            int modelRow = this._dataSetViewerTable.getSortableTableModel().transformToModelRow(viewRow);
            if (null == newColor) {
                this._colorByRow.remove(modelRow);
            }
            int[] nArray = this._dataSetViewerTable.getSelectedColumns();
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer col = nArray[i];
                if (null == newColor) {
                    this._colorByCell.remove(new Point(col, modelRow));
                    continue;
                }
                this._colorByCell.put(new Point(col, modelRow), newColor);
            }
        }
        this._dataSetViewerTable.repaint();
    }

    public Color getBackground(int column, int viewRow, boolean isSelected) {
        if (0 == this._colorByRow.size() && 0 == this._colorByCell.size()) {
            return null;
        }
        int modelRow = this._dataSetViewerTable.getSortableTableModel().transformToModelRow(viewRow);
        this._readBufferPoint.x = column;
        this._readBufferPoint.y = modelRow;
        Color cellColor = this._colorByCell.get(this._readBufferPoint);
        Color backGround = null;
        if (null != cellColor) {
            backGround = isSelected ? cellColor.darker() : cellColor;
        } else {
            Color rowColor = this._colorByRow.get(modelRow);
            if (null != rowColor) {
                backGround = isSelected ? rowColor.darker() : rowColor;
            }
        }
        return backGround;
    }

    public RowColorHandlerState getState() {
        return new RowColorHandlerState(Utilities.cloneObject(this._colorByRow, this._colorByRow.getClass().getClassLoader()));
    }

    public void applyState(RowColorHandlerState rowColorHandlerState) {
        this._colorByRow = rowColorHandlerState.getColorByRow();
    }

    public HashMap<Integer, Color> getColorByRow() {
        return this._colorByRow;
    }

    public HashMap<Point, Color> getColorByCell() {
        return this._colorByCell;
    }

    public void setColorForCell(Point cell, Color color) {
        this._colorByCell.put(cell, color);
    }

    public Set<Integer> getAllColoredRows() {
        HashSet<Integer> ret = new HashSet<Integer>();
        ret.addAll(this._colorByRow.keySet());
        ret.addAll(this._colorByCell.keySet().stream().map(p -> p.y).collect(Collectors.toSet()));
        return ret;
    }
}

