/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.Color;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanelUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicatesColorer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.ValueListReader;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTableModel;

public class DuplicateCellsInSameRowHandler
implements DuplicateHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private HashMap<Integer, HashMap<Object, Color>> _duplicateValuesByRowIndex;
    private Point _cellBuf = new Point();

    public DuplicateCellsInSameRowHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
        this._dataSetViewerTable.getSortableTableModel().addSortingListener(tableSortingAdmin -> this.onSorted());
    }

    private void onSorted() {
        if (null != this._duplicateValuesByRowIndex) {
            this.markDuplicates(true);
        }
    }

    @Override
    public void markDuplicates(boolean selected) {
        if (!selected) {
            this._duplicateValuesByRowIndex = null;
            return;
        }
        this._duplicateValuesByRowIndex = new HashMap();
        SortableTableModel dataSetViewerTableModel = this._dataSetViewerTable.getSortableTableModel();
        for (int j = 0; j < dataSetViewerTableModel.getRowCount(); ++j) {
            List<ExtTableColumn> columns = DataSetViewerTablePanelUtil.getTableColumns(this._dataSetViewerTable);
            int finalJ = j;
            ValueListReader rdr = new ValueListReader(columns.size(), ix -> dataSetViewerTableModel.getValueAt(finalJ, ((ExtTableColumn)columns.get((int)ix)).getModelIndex()));
            HashMap<Object, Color> colorByDuplicateValue = DuplicatesColorer.getColorByDuplicateValueMap(rdr);
            this._duplicateValuesByRowIndex.put(j, colorByDuplicateValue);
        }
    }

    @Override
    public MarkDuplicatesMode getMode() {
        return MarkDuplicatesMode.DUPLICATE_CELLS_IN_ROW;
    }

    @Override
    public Color getBackgroundForCell(int row, int column, Object value) {
        if (null == this._duplicateValuesByRowIndex) {
            return null;
        }
        int columnModelIndex = this._dataSetViewerTable.getColumnModel().getColumn(column).getModelIndex();
        if (-42 == columnModelIndex) {
            return null;
        }
        return this._duplicateValuesByRowIndex.get(row).get(value);
    }
}

