/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.Color;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanelUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class DuplicateCellsInSameRowIfConsecutiveHandler
implements DuplicateHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private HashMap<Point, Color> _colorByCell;
    private Point _cellBuf = new Point();

    public DuplicateCellsInSameRowIfConsecutiveHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
        this._dataSetViewerTable.getSortableTableModel().addSortingListener(tableSortingAdmin -> this.onSorted());
    }

    private void onSorted() {
        if (null != this._colorByCell) {
            this.markDuplicates(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDuplicates(boolean selected) {
        try {
            if (!selected) {
                this._colorByCell = null;
                return;
            }
            this._colorByCell = new HashMap();
            SortableTableModel dataSetViewerTableModel = this._dataSetViewerTable.getSortableTableModel();
            for (int j = 0; j < dataSetViewerTableModel.getRowCount(); ++j) {
                Color curColor = SquirrelConstants.DUPLICATE_COLOR;
                boolean lastWasColored = false;
                List<ExtTableColumn> tableColumns = DataSetViewerTablePanelUtil.getTableColumns(this._dataSetViewerTable);
                for (int i = 1; i < tableColumns.size(); ++i) {
                    Object previousVal;
                    int columnModelIndex = tableColumns.get(i).getModelIndex();
                    int previousColumnModelIndex = tableColumns.get(i - 1).getModelIndex();
                    Object val = dataSetViewerTableModel.getValueAt(j, columnModelIndex);
                    if (Utilities.equalsRespectNull(val, previousVal = dataSetViewerTableModel.getValueAt(j, previousColumnModelIndex))) {
                        this._colorByCell.put(new Point(columnModelIndex, j), curColor);
                        this._colorByCell.put(new Point(previousColumnModelIndex, j), curColor);
                        lastWasColored = true;
                        continue;
                    }
                    if (!lastWasColored) continue;
                    curColor = curColor == SquirrelConstants.DUPLICATE_COLOR ? SquirrelConstants.DUPLICATE_COLOR_DARKER : SquirrelConstants.DUPLICATE_COLOR;
                    lastWasColored = false;
                }
            }
        }
        finally {
            this._dataSetViewerTable.repaint();
        }
    }

    @Override
    public MarkDuplicatesMode getMode() {
        return MarkDuplicatesMode.DUPLICATE_CONSECUTIVE_CELLS_IN_ROW;
    }

    @Override
    public Color getBackgroundForCell(int row, int column, Object value) {
        int columnModelIndex;
        if (null == this._colorByCell) {
            return null;
        }
        this._cellBuf.x = columnModelIndex = this._dataSetViewerTable.getColumnModel().getColumn(column).getModelIndex();
        this._cellBuf.y = row;
        return this._colorByCell.get(this._cellBuf);
    }
}

