/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.Color;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicatesColorer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.RowWrapper;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.ValueListReader;

public class DuplicateRowsHandler
implements DuplicateHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private HashMap<Object, Color> _colorByDuplicateRow;

    public DuplicateRowsHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDuplicates(boolean selected) {
        try {
            if (!selected) {
                this._colorByDuplicateRow = null;
                return;
            }
            DataSetViewerTableModel dataSetViewerTableModel = this._dataSetViewerTable.getDataSetViewerTableModel();
            ValueListReader rdr = new ValueListReader(dataSetViewerTableModel.getRowCount(), ix -> new RowWrapper(dataSetViewerTableModel, (int)ix));
            this._colorByDuplicateRow = DuplicatesColorer.getColorByDuplicateValueMap(rdr);
        }
        finally {
            this._dataSetViewerTable.repaint();
        }
    }

    @Override
    public MarkDuplicatesMode getMode() {
        return MarkDuplicatesMode.DUPLICATE_ROWS;
    }

    @Override
    public Color getBackgroundForCell(int row, int column, Object value) {
        if (null == this._colorByDuplicateRow) {
            return null;
        }
        RowWrapper rowWrapperBuf = new RowWrapper();
        rowWrapperBuf.init(this._dataSetViewerTable.getDataSetViewerTableModel(), row);
        return this._colorByDuplicateRow.get(rowWrapperBuf);
    }
}

