/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.Color;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanelUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicateHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.DuplicatesColorer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.ValueListReader;

public class DuplicateValuesInColumnsHandler
implements DuplicateHandler {
    private DataSetViewerTable _dataSetViewerTable;
    private HashMap<Integer, HashMap<Object, Color>> _duplicateValuesByColumnModelIndex;

    public DuplicateValuesInColumnsHandler(DataSetViewerTable dataSetViewerTable) {
        this._dataSetViewerTable = dataSetViewerTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDuplicates(boolean selected) {
        try {
            if (!selected) {
                this._duplicateValuesByColumnModelIndex = null;
                return;
            }
            this._duplicateValuesByColumnModelIndex = new HashMap();
            DataSetViewerTableModel dataSetViewerTableModel = this._dataSetViewerTable.getDataSetViewerTableModel();
            for (ExtTableColumn tableColumn : DataSetViewerTablePanelUtil.getTableColumns(this._dataSetViewerTable)) {
                int columnModelIndex = tableColumn.getModelIndex();
                ValueListReader rdr = new ValueListReader(dataSetViewerTableModel.getRowCount(), ix -> dataSetViewerTableModel.getValueAt((int)ix, columnModelIndex));
                HashMap<Object, Color> colorByDuplicateValue = DuplicatesColorer.getColorByDuplicateValueMap(rdr);
                this._duplicateValuesByColumnModelIndex.put(columnModelIndex, colorByDuplicateValue);
            }
        }
        finally {
            this._dataSetViewerTable.repaint();
        }
    }

    @Override
    public MarkDuplicatesMode getMode() {
        return MarkDuplicatesMode.DUPLICATE_VALUES_IN_COLUMNS;
    }

    @Override
    public Color getBackgroundForCell(int row, int column, Object value) {
        if (null == this._duplicateValuesByColumnModelIndex) {
            return null;
        }
        int columnModelIndex = this._dataSetViewerTable.getColumnModel().getColumn(column).getModelIndex();
        if (-42 == columnModelIndex) {
            return null;
        }
        return this._duplicateValuesByColumnModelIndex.get(columnModelIndex).get(value);
    }
}

