/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.MarkDuplicatesToggleAction;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates.MarkDuplicatesMode;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonChooser;
import net.sourceforge.squirrel_sql.fw.gui.table.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class MarkDuplicatesChooserController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MarkDuplicatesChooserController.class);
    private final IDataSetViewer _sqlResultDataSetViewer;
    private ButtonChooser _toggleBtnChooser;
    private static final String PREF_MARK_DUPLICATES_MODE_LAST_MODE = "MarkDuplicatesMode.last.mode";
    private boolean _dontReactToEvents = false;

    public MarkDuplicatesChooserController(IDataSetViewer dataSetViewer) {
        this(dataSetViewer, null);
    }

    public MarkDuplicatesChooserController(IResultTab resultTab) {
        this(resultTab.getSQLResultDataSetViewer(), resultTab);
    }

    private MarkDuplicatesChooserController(IDataSetViewer dataSetViewer, IResultTab resultTab) {
        this._sqlResultDataSetViewer = dataSetViewer;
        this._toggleBtnChooser = new ButtonChooser();
        for (MarkDuplicatesMode mode : MarkDuplicatesMode.values()) {
            JToggleButton btn;
            if (null != resultTab) {
                btn = new JToggleButton(new MarkDuplicatesToggleAction(resultTab));
            } else {
                btn = new JToggleButton();
                btn.addActionListener(e -> this.actionWasFired(e));
            }
            btn.setIcon(mode.getIcon());
            btn.setText(mode.getText());
            btn.setToolTipText(mode.getToolTipText());
            mode.assignModeToButton(btn);
            this._toggleBtnChooser.addButton(btn);
        }
        this._toggleBtnChooser.setSelectedButton(this.getLastMode().findButton(this._toggleBtnChooser));
        this._toggleBtnChooser.setButtonSelectedListener((newSelectedButton, formerSelectedButton) -> this.onButtonSelected((JToggleButton)newSelectedButton, (JToggleButton)formerSelectedButton));
        if (this._sqlResultDataSetViewer instanceof DataSetViewerTablePanel) {
            SortableTableModel sortableTableModel = ((DataSetViewerTablePanel)this._sqlResultDataSetViewer).getTable().getSortableTableModel();
            sortableTableModel.addSortingListener(tableSortingAdmin -> this.onTableSorted());
        }
        if (this._sqlResultDataSetViewer instanceof DataSetViewerTablePanel) {
            ((DataSetViewerTablePanel)this._sqlResultDataSetViewer).getTable().getButtonTableHeader().setDraggedColumnListener(() -> this.onColumnMoved());
        }
    }

    private void onColumnMoved() {
        AbstractButton selButton = this._toggleBtnChooser.getSelectedButton();
        if (!selButton.isSelected()) {
            return;
        }
        MarkDuplicatesMode selectedMode = MarkDuplicatesMode.getModeByButton(selButton);
        if (selectedMode == MarkDuplicatesMode.DUPLICATE_CONSECUTIVE_CELLS_IN_ROW || selectedMode == MarkDuplicatesMode.DUPLICATE_CONSECUTIVE_VALUES_IN_COLUMNS) {
            try {
                this._dontReactToEvents = true;
                selButton.setSelected(false);
            }
            finally {
                this._dontReactToEvents = false;
            }
            this.doMarkDuplicates();
        }
    }

    private void onTableSorted() {
        AbstractButton selButton = this._toggleBtnChooser.getSelectedButton();
        if (!selButton.isSelected()) {
            return;
        }
        MarkDuplicatesMode selectedMode = MarkDuplicatesMode.getModeByButton(selButton);
        if (selectedMode == MarkDuplicatesMode.DUPLICATE_CONSECUTIVE_VALUES_IN_COLUMNS || selectedMode == MarkDuplicatesMode.DUPLICATE_CONSECUTIVE_ROWS) {
            try {
                this._dontReactToEvents = true;
                selButton.setSelected(false);
            }
            finally {
                this._dontReactToEvents = false;
            }
            this.doMarkDuplicates();
        }
    }

    private void onButtonSelected(JToggleButton newSelectedButton, JToggleButton formerSelectedButton) {
        if (this._dontReactToEvents) {
            return;
        }
        Props.putString(PREF_MARK_DUPLICATES_MODE_LAST_MODE, MarkDuplicatesMode.getModeByButton(newSelectedButton).name());
        try {
            this._dontReactToEvents = true;
            newSelectedButton.setSelected(formerSelectedButton.isSelected());
            newSelectedButton.setContentAreaFilled(newSelectedButton.isSelected());
        }
        finally {
            this._dontReactToEvents = false;
        }
        this.doMarkDuplicates();
    }

    private MarkDuplicatesMode getLastMode() {
        return MarkDuplicatesMode.valueOf(Props.getString(PREF_MARK_DUPLICATES_MODE_LAST_MODE, MarkDuplicatesMode.DUPLICATE_VALUES_IN_COLUMNS.name()));
    }

    public JComponent getComponent() {
        return this._toggleBtnChooser.getComponent();
    }

    public boolean actionWasFired(ActionEvent e) {
        if (this._dontReactToEvents) {
            return true;
        }
        if (e.getSource() != this._toggleBtnChooser.getSelectedButton()) {
            this._toggleBtnChooser.getSelectedButton().doClick();
            return false;
        }
        this.doMarkDuplicates();
        return true;
    }

    private void doMarkDuplicates() {
        if (!(this._sqlResultDataSetViewer instanceof DataSetViewerTablePanel)) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("MarkDuplicatesChooserController.mark.duplicates.for.table.output.only"));
            return;
        }
        boolean selected = this._toggleBtnChooser.getSelectedButton().isSelected();
        MarkDuplicatesMode mode = null;
        if (selected) {
            mode = MarkDuplicatesMode.getModeByButton(this._toggleBtnChooser.getSelectedButton());
        }
        ((DataSetViewerTablePanel)this._sqlResultDataSetViewer).getTable().getColoringService().getMarkDuplicatesHandler().markDuplicates(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStateFrom(MarkDuplicatesChooserController controllerToCopyFrom) {
        try {
            this._dontReactToEvents = true;
            for (AbstractButton button : this._toggleBtnChooser.getAllButtons()) {
                if (button.getIcon() != controllerToCopyFrom._toggleBtnChooser.getSelectedButton().getIcon()) continue;
                this._toggleBtnChooser.setSelectedButton(button);
                button.setSelected(controllerToCopyFrom._toggleBtnChooser.getSelectedButton().isSelected());
                break;
            }
            this._toggleBtnChooser.getSelectedButton().setContentAreaFilled(this._toggleBtnChooser.getSelectedButton().isSelected());
        }
        finally {
            this._dontReactToEvents = false;
        }
    }
}

