/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.buttonchooser.ButtonChooser;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public enum MarkDuplicatesMode {
    DUPLICATE_VALUES_IN_COLUMNS(Main.getApplication().getResources().getIcon("duplicateValuesInColumns"), I18n.s_stringMgr.getString("MarkDuplicatesMode.duplicateValuesInColumns.text"), I18n.embedInUsageInfo("MarkDuplicatesMode.duplicateValuesInColumns.tooltip")),
    DUPLICATE_CONSECUTIVE_VALUES_IN_COLUMNS(Main.getApplication().getResources().getIcon("duplicateValuesInColumnsIfConsecutive"), I18n.s_stringMgr.getString("MarkDuplicatesMode.duplicateValuesInColumnsIfConsecutive.text"), I18n.embedInUsageInfo("MarkDuplicatesMode.duplicateValuesInColumnsIfConsecutive.tooltip")),
    DUPLICATE_ROWS(Main.getApplication().getResources().getIcon("duplicateRows"), I18n.s_stringMgr.getString("MarkDuplicatesMode.duplicateRows.text"), I18n.embedInUsageInfo("MarkDuplicatesMode.duplicateRows.tooltip")),
    DUPLICATE_CONSECUTIVE_ROWS(Main.getApplication().getResources().getIcon("duplicateRowsIfConsecutive"), I18n.s_stringMgr.getString("MarkDuplicatesMode.duplicateRowsIfConsecutive.text"), I18n.embedInUsageInfo("MarkDuplicatesMode.duplicateRowsIfConsecutive.tooltip")),
    DUPLICATE_CELLS_IN_ROW(Main.getApplication().getResources().getIcon("duplicateCellsInRow"), I18n.s_stringMgr.getString("MarkDuplicatesMode.duplicateCellsInSameRow.text"), I18n.embedInUsageInfo("MarkDuplicatesMode.duplicateCellsInSameRow.tooltip")),
    DUPLICATE_CONSECUTIVE_CELLS_IN_ROW(Main.getApplication().getResources().getIcon("duplicateCellsInRowIfConsecutive"), I18n.s_stringMgr.getString("MarkDuplicatesMode.duplicateCellsInSameRowIfConsecutive.text"), I18n.embedInUsageInfo("MarkDuplicatesMode.duplicateCellsInSameRowIfConsecutive.tooltip"));

    private final ImageIcon _icon;
    private final String _text;
    private final String _toolTip;

    private MarkDuplicatesMode(ImageIcon icon, String text, String toolTip) {
        this._icon = icon;
        this._text = text;
        this._toolTip = toolTip;
    }

    public void assignModeToButton(JToggleButton btn) {
        btn.putClientProperty(MarkDuplicatesMode.class, (Object)this);
    }

    public static MarkDuplicatesMode getModeByButton(AbstractButton button) {
        return (MarkDuplicatesMode)((Object)button.getClientProperty(MarkDuplicatesMode.class));
    }

    public Icon getIcon() {
        return this._icon;
    }

    public String getText() {
        return this._text;
    }

    public String getToolTipText() {
        return this._toolTip;
    }

    public JToggleButton findButton(ButtonChooser buttonChooser) {
        Optional<AbstractButton> ret = buttonChooser.getAllButtons().stream().filter(b -> b.getClientProperty(MarkDuplicatesMode.class) == this).findFirst();
        if (!ret.isPresent()) {
            throw new IllegalStateException("No Button found for mode " + this.name());
        }
        return (JToggleButton)ret.get();
    }

    private static class I18n {
        static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MarkDuplicatesMode.class);

        private I18n() {
        }

        static String embedInUsageInfo(String toEmbed) {
            return s_stringMgr.getString("MarkDuplicatesMode.usage.tooltip.embed", s_stringMgr.getString(toEmbed));
        }
    }
}

