/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.coloring.markduplicates;

import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.gui.table.SquirrelTableCellValueCollator;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class RowWrapper
implements Comparable<RowWrapper> {
    private DataSetViewerTableModel _dataSetViewerTableModel;
    private int _modelRow;
    private SquirrelTableCellValueCollator _collator = new SquirrelTableCellValueCollator();

    public RowWrapper(DataSetViewerTableModel dataSetViewerTableModel, int modelRow) {
        this.init(dataSetViewerTableModel, modelRow);
    }

    public RowWrapper() {
    }

    public void init(DataSetViewerTableModel dataSetViewerTableModel, int rowIndex) {
        this._dataSetViewerTableModel = dataSetViewerTableModel;
        this._modelRow = rowIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowWrapper other = (RowWrapper)o;
        for (int i = 0; i < this._dataSetViewerTableModel.getColumnCount(); ++i) {
            if (Utilities.equalsRespectNull(this.getCellValueAtColumn(i), other.getCellValueAtColumn(i))) continue;
            return false;
        }
        return true;
    }

    private Object getCellValueAtColumn(int col) {
        return this._dataSetViewerTableModel.getValueAt(this._modelRow, col);
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this._dataSetViewerTableModel.getColumnCount(); ++i) {
            int buf = this.getCellValueAtColumn(i) != null ? this.getCellValueAtColumn(i).hashCode() : 0;
            result = 31 * buf + result;
        }
        return result;
    }

    @Override
    public int compareTo(RowWrapper other) {
        for (int i = 0; i < this._dataSetViewerTableModel.getColumnCount(); ++i) {
            int compareResult = this._collator.compareTableCellValues(this.getCellValueAtColumn(i), other.getCellValueAtColumn(i), 1, false, false);
            if (0 == compareResult) continue;
            return compareResult;
        }
        return 0;
    }
}

