/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.DisplayMode;
import org.apache.commons.lang3.tuple.Pair;

public class CellDetailDisplayModeManager {
    private List<Pair<ColumnDisplayDefinition, DisplayMode>> _columnsToNonDefaultDisplayMode = new ArrayList<Pair<ColumnDisplayDefinition, DisplayMode>>();

    public void putDisplayMode(ColumnDisplayDefinition currentColumnDisplayDefinition, DisplayMode displayMode) {
        this._columnsToNonDefaultDisplayMode.removeIf(p -> ((ColumnDisplayDefinition)p.getLeft()).matchesByQualifiedName(currentColumnDisplayDefinition));
        if (displayMode != DisplayMode.DEFAULT) {
            this._columnsToNonDefaultDisplayMode.add((Pair<ColumnDisplayDefinition, DisplayMode>)Pair.of((Object)currentColumnDisplayDefinition, (Object)((Object)displayMode)));
        }
    }

    public DisplayMode getNonDefaultDisplayMode(ColumnDisplayDefinition cdd) {
        Optional<Pair> nonDefaultDisplay = this._columnsToNonDefaultDisplayMode.stream().filter(p -> ((ColumnDisplayDefinition)p.getLeft()).matchesByQualifiedName(cdd)).findFirst();
        if (nonDefaultDisplay.isPresent()) {
            return (DisplayMode)((Object)nonDefaultDisplay.get().getRight());
        }
        return null;
    }
}

