/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.CellDetailCloseListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.DisplayMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.DisplayPanelListener;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallToolTipInfoButton;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class CellDisplayPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CellDisplayPanel.class);
    private final JPanel _pnlContent = new JPanel(new GridLayout(1, 1));
    private final DisplayPanelListener _displayPanelListener;
    private final CellDetailCloseListener _cellDetailCloseListener;
    private ColumnDisplayDefinition _currentColumnDisplayDefinition;
    private JComboBox<DisplayMode> _cboDisplayMode = new JComboBox<DisplayMode>(DisplayMode.values());
    private JButton _btnClose = new JButton(Main.getApplication().getResources().getIcon("close"));

    public CellDisplayPanel(DisplayPanelListener displayPanelListener) {
        this(displayPanelListener, null);
    }

    public CellDisplayPanel(DisplayPanelListener displayPanelListener, CellDetailCloseListener cellDetailCloseListener) {
        this._displayPanelListener = displayPanelListener;
        this._cellDetailCloseListener = cellDetailCloseListener;
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)this.createDisplaySelectionPanel(), "North");
        this.add((Component)this._pnlContent, "Center");
        this._cboDisplayMode.setSelectedItem((Object)DisplayMode.DEFAULT);
        this._cboDisplayMode.addItemListener(e -> this.onDisplayModeChanged(e));
    }

    private void onDisplayModeChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            return;
        }
        if (null != this._currentColumnDisplayDefinition) {
            Main.getApplication().getCellDetailDisplayModeManager().putDisplayMode(this._currentColumnDisplayDefinition, this.getDisplayMode());
        }
        this._displayPanelListener.displayModeChanged();
    }

    private JPanel createDisplaySelectionPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0);
        JLabel lbl = new JLabel(s_stringMgr.getString("DisplayPanel.select.display"));
        ret.add((Component)lbl, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0);
        ret.add(GUIUtils.setPreferredWidth(this._cboDisplayMode, this._cboDisplayMode.getPreferredSize().width + 40), gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 0), 0, 0);
        ret.add((Component)new SmallToolTipInfoButton(s_stringMgr.getString("DisplayPanel.info.button")).getButton(), gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 0), 0, 0);
        ret.add((Component)new JPanel(), gbc);
        if (null != this._cellDetailCloseListener) {
            gbc = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
            ret.add((Component)GUIUtils.styleAsToolbarButton(this._btnClose), gbc);
            this._btnClose.addActionListener(e -> this._cellDetailCloseListener.close());
        }
        return ret;
    }

    public void setContentComponent(JComponent contentComponent) {
        this._pnlContent.removeAll();
        this._pnlContent.add(contentComponent);
    }

    public void setCurrentColumnDisplayDefinition(ColumnDisplayDefinition cdd) {
        this._currentColumnDisplayDefinition = cdd;
        DisplayMode modeToSel = Main.getApplication().getCellDetailDisplayModeManager().getNonDefaultDisplayMode(cdd);
        if (null == modeToSel) {
            modeToSel = DisplayMode.DEFAULT;
        }
        this._cboDisplayMode.setSelectedItem((Object)modeToSel);
    }

    public DisplayMode getDisplayMode() {
        return (DisplayMode)((Object)this._cboDisplayMode.getSelectedItem());
    }
}

