/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataColumnDataPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataUpdateInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.CellDetailCloseListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.CellDetailDisplayAvailableInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.CellDisplayPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ColumnDisplayUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.DisplayMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ResultImageDisplayPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ResultTableType;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ResultDataSetAndCellDetailDisplayHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultDataSetAndCellDetailDisplayHandler.class);
    private static final String PREF_KEY_CELL_DETAIL_DIVIDER_POS = "ResultDataSetAndCellDetailDisplayHandler.cell.detail.divider.pos";
    private final JLabel _lblNoCell;
    private final CellDisplayPanel _rightCellDisplayPanel;
    private IDataSetViewer _dataSetViewer;
    private final ResultTableType _resultTableType;
    private JScrollPane _scrollPane;
    private JSplitPane _splitPane;
    private boolean _adjustingSplitPane = false;
    private CellDetailCloseListener _cellDetailCloseListener;
    private boolean _cellDetailSplitActive;

    public ResultDataSetAndCellDetailDisplayHandler(IDataSetViewer dataSetViewer, ResultTableType resultTableType) {
        this._dataSetViewer = dataSetViewer;
        this._resultTableType = resultTableType;
        this._scrollPane = new JScrollPane();
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._scrollPane.setViewportView(this._dataSetViewer.getComponent());
        this._splitPane = new JSplitPane();
        this._splitPane.setLeftComponent(this._scrollPane);
        this._lblNoCell = new JLabel("No cell selected");
        GUIUtils.setPreferredWidth(this._lblNoCell, 0);
        GUIUtils.setMinimumWidth(this._lblNoCell, 0);
        this._rightCellDisplayPanel = new CellDisplayPanel(() -> this.onDisplayChanged(), () -> this.onClose());
        this._splitPane.setRightComponent(this._rightCellDisplayPanel);
        this._splitPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ResultDataSetAndCellDetailDisplayHandler.this.onSplitPaneResized();
            }
        });
        if (resultTableType == ResultTableType.SQL_QUERY_RESULT && this.isDataSetViewerTablePanel()) {
            this.setCellDetailVisible(ColumnDisplayUtil.isShowCellDetail(), true);
            this._splitPane.addPropertyChangeListener("dividerLocation", e -> this.onDividerLocationChanged(e));
            this._dataSetViewer.addRowColSelectedCountListener((selRowCount, selColCount, selRow, selCol) -> this.onRowColSelectionChanged((DataSetViewerTablePanel)this._dataSetViewer));
        } else {
            this.setCellDetailVisible(false, true);
        }
    }

    private void onClose() {
        if (null != this._cellDetailCloseListener) {
            this._cellDetailCloseListener.close();
        }
    }

    private void onSplitPaneResized() {
        if (!this.isCellDetailSplitActive()) {
            this._splitPane.setDividerLocation(Integer.MAX_VALUE);
        }
    }

    private void onRowColSelectionChanged(DataSetViewerTablePanel dataSetViewer) {
        if (!this.isCellDetailSplitActive()) {
            return;
        }
        int rowLeadSelectionIndex = dataSetViewer.getTable().getSelectionModel().getLeadSelectionIndex();
        int colLeadSelectionIndex = dataSetViewer.getTable().getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (-1 == rowLeadSelectionIndex || -1 == colLeadSelectionIndex || !(dataSetViewer.getTable().getColumnModel().getColumn(colLeadSelectionIndex) instanceof ExtTableColumn)) {
            int dividerLocBuf = this._splitPane.getDividerLocation();
            this._rightCellDisplayPanel.setContentComponent(this._lblNoCell);
            this._splitPane.setDividerLocation(dividerLocBuf);
        } else {
            JPanel pnlToDisplay;
            Object value = dataSetViewer.getTable().getValueAt(rowLeadSelectionIndex, colLeadSelectionIndex);
            ExtTableColumn column = (ExtTableColumn)dataSetViewer.getTable().getColumnModel().getColumn(colLeadSelectionIndex);
            this._rightCellDisplayPanel.setCurrentColumnDisplayDefinition(column.getColumnDisplayDefinition());
            if (DisplayMode.IMAGE == this._rightCellDisplayPanel.getDisplayMode()) {
                pnlToDisplay = new ResultImageDisplayPanel(column.getColumnDisplayDefinition(), value, dataSetViewer.isTableEditable(), rowLeadSelectionIndex, colLeadSelectionIndex, dataSetViewer.getTable());
            } else {
                CellDataColumnDataPanel panel = new CellDataColumnDataPanel(value, column.getColumnDisplayDefinition(), dataSetViewer.isTableEditable());
                panel.setCellDataUpdateInfo(new CellDataUpdateInfo(rowLeadSelectionIndex, colLeadSelectionIndex, dataSetViewer.getTable(), null));
                pnlToDisplay = panel;
            }
            GUIUtils.setPreferredWidth(pnlToDisplay, 0);
            GUIUtils.setMinimumWidth(pnlToDisplay, 0);
            int dividerLocBuf = this._splitPane.getDividerLocation();
            this._rightCellDisplayPanel.setContentComponent(pnlToDisplay);
            this._splitPane.setDividerLocation(dividerLocBuf);
        }
    }

    private void onDividerLocationChanged(PropertyChangeEvent e) {
        if (this._adjustingSplitPane || !this.isCellDetailSplitActive()) {
            return;
        }
        Props.putInt(PREF_KEY_CELL_DETAIL_DIVIDER_POS, (Integer)e.getNewValue());
    }

    public IDataSetViewer getDataSetViewer() {
        return this._dataSetViewer;
    }

    public boolean isDataSetViewerTablePanel() {
        return this._dataSetViewer instanceof DataSetViewerTablePanel;
    }

    public DataSetViewerTablePanel getDataSetViewerTablePanel() {
        if (!this.isDataSetViewerTablePanel()) {
            throw new IllegalStateException("Call isDataSetViewerTablePanel() first to check if the _dataSetViewer is a DataSetViewerTablePanel");
        }
        return (DataSetViewerTablePanel)this._dataSetViewer;
    }

    public IDataSetViewer replaceDataSetViewer(IDataSetViewer dataSetViewer) {
        IDataSetViewer previousDataSetViewer = this._dataSetViewer;
        if (null != this._dataSetViewer) {
            this._dataSetViewer.disableContinueRead();
        }
        this._dataSetViewer = dataSetViewer;
        this._dataSetViewer.moveRowColListenersToMe(previousDataSetViewer);
        this._scrollPane.setViewportView(this._dataSetViewer.getComponent());
        this._scrollPane.setRowHeader(null);
        return previousDataSetViewer;
    }

    public CellDetailDisplayAvailableInfo getCellDetailDisplayAvailableInfo() {
        if (!this.isDataSetViewerTablePanel()) {
            return new CellDetailDisplayAvailableInfo(s_stringMgr.getString("ResultDataSetAndCellDetailDisplayHandler.display.choice.for.table.only"));
        }
        if (this._resultTableType != ResultTableType.SQL_QUERY_RESULT) {
            return new CellDetailDisplayAvailableInfo(s_stringMgr.getString("ResultDataSetAndCellDetailDisplayHandler.display.choice.when.query.result.selected.only"));
        }
        return CellDetailDisplayAvailableInfo.INFO_DISPLAY_AVAILABLE;
    }

    public JSplitPane getComponent() {
        return this._splitPane;
    }

    public void setCellDetailVisible(boolean b) {
        this.setCellDetailVisible(b, false);
    }

    private void setCellDetailVisible(boolean visible, boolean initializing) {
        try {
            this._adjustingSplitPane = true;
            if (!visible && (this.isCellDetailSplitActive() || initializing)) {
                this._splitPane.setDividerLocation(Integer.MAX_VALUE);
                this._splitPane.setDividerSize(0);
                this.setCellDetailSplitActive(false);
            } else if (visible && (!this.isCellDetailSplitActive() || initializing)) {
                this.setCellDetailSplitActive(true);
                this._splitPane.setDividerSize(new JSplitPane().getDividerSize());
                this._splitPane.setDividerLocation(Props.getInt(PREF_KEY_CELL_DETAIL_DIVIDER_POS, this._splitPane.getMaximumDividerLocation() / 2));
                if (this._dataSetViewer instanceof DataSetViewerTablePanel) {
                    this.fireCellSelectionChangedForCurrentSelectedCell();
                }
            }
            if (!initializing) {
                ColumnDisplayUtil.setShowCellDetail(this.isCellDetailSplitActive());
            }
        }
        finally {
            this._adjustingSplitPane = false;
        }
    }

    private void setCellDetailSplitActive(boolean enabled) {
        this._cellDetailSplitActive = enabled;
    }

    private boolean isCellDetailSplitActive() {
        return this._cellDetailSplitActive;
    }

    private void fireCellSelectionChangedForCurrentSelectedCell() {
        this.onRowColSelectionChanged((DataSetViewerTablePanel)this._dataSetViewer);
    }

    private void onDisplayChanged() {
        this.fireCellSelectionChangedForCurrentSelectedCell();
    }

    public void setCloseListener(CellDetailCloseListener cellDetailCloseListener) {
        this._cellDetailCloseListener = cellDetailCloseListener;
    }
}

