/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.file.Files;
import java.util.Base64;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.dnd.DropedFileExtractor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BlobDescriptor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeBlobProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClobProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ColumnDisplayUtil;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ResultImageDisplayPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultImageDisplayPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(ResultImageDisplayPanel.class);
    private final JScrollPane _scrImage = new JScrollPane();

    public ResultImageDisplayPanel(ColumnDisplayDefinition cdd, Object valueToDisplay, boolean tableEditable, int selRow, int selCol, DataSetViewerTable table) {
        this.setLayout(new BorderLayout(3, 3));
        this.add((Component)this._scrImage, "Center");
        this.updateImageDisplay(cdd, valueToDisplay);
        if (tableEditable) {
            this.add((Component)this.createUpdatePanel(selRow, selCol, table, cdd), "South");
        }
    }

    private void updateImageDisplay(ColumnDisplayDefinition cdd, Object valueToDisplay) {
        this._scrImage.setViewportView(this.getDisplayComponent(cdd, valueToDisplay));
    }

    private JPanel createUpdatePanel(final int selRow, final int selCol, final DataSetViewerTable table, final ColumnDisplayDefinition cdd) {
        JPanel ret = new JPanel(new BorderLayout(0, 3));
        JLabel lblDrop = new JLabel(s_stringMgr.getString("ResultImageDisplayPanel.drop.image.file.here"));
        lblDrop.setToolTipText(s_stringMgr.getString("ResultImageDisplayPanel.drop.image.file.here.tooltip"));
        DropTarget dt = new DropTarget(lblDrop, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                ResultImageDisplayPanel.this.onDrop(dtde, selRow, selCol, table, cdd);
            }
        });
        lblDrop.setDropTarget(dt);
        JPanel pnlBorder = new JPanel(new GridLayout(1, 1));
        pnlBorder.add(lblDrop);
        pnlBorder.setBorder(BorderFactory.createEtchedBorder());
        ret.add((Component)pnlBorder, "Center");
        JButton btnDel = new JButton(Main.getApplication().getResources().getIcon("delete"));
        btnDel.setToolTipText(s_stringMgr.getString("ResultImageDisplayPanel.delete.image.from.database.tooltip"));
        btnDel.addActionListener(e -> this.onDelete(selRow, selCol, table, cdd));
        ret.add((Component)GUIUtils.styleAsToolbarButton(btnDel), "East");
        return ret;
    }

    private void onDelete(int selRow, int selCol, DataSetViewerTable table, ColumnDisplayDefinition cdd) {
        if (0 != JOptionPane.showConfirmDialog(this, s_stringMgr.getString("ResultImageDisplayPanel.delete.image"))) {
            return;
        }
        if (null != table.getCellEditor()) {
            table.getCellEditor().cancelCellEditing();
        }
        table.setValueAt(null, selRow, selCol);
        table.repaint();
        this.updateImageDisplay(cdd, null);
    }

    private void onDrop(DropTargetDropEvent dtde, int selRow, int selCol, DataSetViewerTable table, ColumnDisplayDefinition cdd) {
        File fileBuf = null;
        try {
            List<File> files = DropedFileExtractor.getFiles(dtde);
            if (files.isEmpty()) {
                Main.getApplication().getMessageHandler().showWarningMessage("ResultImageDisplayPanel.no.file.dropped");
                return;
            }
            if (null != table.getCellEditor()) {
                table.getCellEditor().cancelCellEditing();
            }
            fileBuf = files.get(0);
            byte[] bytes = Files.readAllBytes(fileBuf.toPath());
            if (cdd.getSqlType() == 12 || cdd.getSqlType() == -1 || cdd.getSqlType() == -16 || cdd.getSqlType() == 2005) {
                table.setValueAt(new String(Base64.getEncoder().encode(bytes)), selRow, selCol);
            } else {
                table.setValueAt(bytes, selRow, selCol);
            }
            table.repaint();
            this.updateImageDisplay(cdd, table.getValueAt(selRow, selCol));
        }
        catch (Exception e) {
            String msg = s_stringMgr.getString("ResultImageDisplayPanel.failed.to.read.file", fileBuf, e);
            s_log.error(msg, e);
            Main.getApplication().getMessageHandler().showErrorMessage(msg);
        }
    }

    private JComponent getDisplayComponent(ColumnDisplayDefinition cdd, Object valueToDisplay) {
        try {
            Object data;
            BufferedImage image;
            if (null == valueToDisplay) {
                return new JLabel("<null>");
            }
            if (valueToDisplay instanceof String) {
                image = ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode((String)valueToDisplay)));
            } else if (valueToDisplay instanceof BlobDescriptor) {
                data = ((BlobDescriptor)valueToDisplay).getData();
                if (null == data) {
                    if (!ResultImageDisplayPanel.isReadCompleteBlobs()) {
                        String msg = s_stringMgr.getString("ResultImageDisplayPanel.null.blob.not.read", "<null>");
                        return new MultipleLineLabel(msg);
                    }
                    return new JLabel("<null>");
                }
                image = ImageIO.read(new ByteArrayInputStream(Utilities.toPrimitiveByteArray(data)));
            } else if (valueToDisplay instanceof ClobDescriptor) {
                data = ((ClobDescriptor)valueToDisplay).getData();
                if (null == data) {
                    if (!ResultImageDisplayPanel.isReadCompleteClobs()) {
                        String msg = s_stringMgr.getString("ResultImageDisplayPanel.null.clob.not.read", "<null>");
                        return new MultipleLineLabel(msg);
                    }
                    return new JLabel("<null>");
                }
                image = ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode((String)data)));
            } else {
                image = ImageIO.read(new ByteArrayInputStream(Utilities.toPrimitiveByteArray(valueToDisplay)));
            }
            if (null == image) {
                String msg = s_stringMgr.getString("ResultImageDisplayPanel.could.create.image", ColumnDisplayUtil.getColumnName(cdd), cdd.getSqlTypeName());
                if (cdd.getSqlType() == 2004 && !ResultImageDisplayPanel.isReadCompleteClobs()) {
                    msg = s_stringMgr.getString("ResultImageDisplayPanel.could.create.image.blob.not.read", ColumnDisplayUtil.getColumnName(cdd), cdd.getSqlTypeName());
                } else if (cdd.getSqlType() == 2005 && !ResultImageDisplayPanel.isReadCompleteBlobs()) {
                    msg = s_stringMgr.getString("ResultImageDisplayPanel.could.create.image.clob.not.read", ColumnDisplayUtil.getColumnName(cdd), cdd.getSqlTypeName());
                }
                s_log.error(msg);
                Main.getApplication().getMessageHandler().showErrorMessage(msg);
                return new MultipleLineLabel(msg);
            }
            JLabel lblImage = new JLabel();
            lblImage.setIcon(new ImageIcon(image));
            return lblImage;
        }
        catch (Exception e) {
            String msg = s_stringMgr.getString("ResultImageDisplayPanel.image.display.error", ColumnDisplayUtil.getColumnName(cdd), cdd.getSqlTypeName(), e);
            if (cdd.getSqlType() == 2004 && !ResultImageDisplayPanel.isReadCompleteClobs()) {
                msg = s_stringMgr.getString("ResultImageDisplayPanel.image.display.error.blob.not.read", ColumnDisplayUtil.getColumnName(cdd), cdd.getSqlTypeName(), e);
            } else if (cdd.getSqlType() == 2005 && !ResultImageDisplayPanel.isReadCompleteBlobs()) {
                msg = s_stringMgr.getString("ResultImageDisplayPanel.image.display.error.clob.not.read", ColumnDisplayUtil.getColumnName(cdd), cdd.getSqlTypeName(), e);
            }
            s_log.error(msg, e);
            Main.getApplication().getMessageHandler().showErrorMessage(msg);
            return new MultipleLineLabel(msg);
        }
    }

    private static boolean isReadCompleteClobs() {
        DataTypeBlobProperties props = new DataTypeBlobProperties().loadProperties();
        return props.isReadCompleteBlobs() && false == props.isReadBlobsNever();
    }

    private static boolean isReadCompleteBlobs() {
        DataTypeClobProperties props = new DataTypeClobProperties().loadProperties();
        return props.isReadCompleteClobs() && false == props.isReadClobsNever();
    }
}

