/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice;

import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.mainpanel.ResultTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.resulttabactions.ResultTabProvider;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.CellDetailDisplayAvailableInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ColumnDisplayUtil;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ResultDataSetAndCellDetailDisplayHandler;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ShowCellDetailCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ShowCellDetailCtrl.class);
    private static ILogger s_log = LoggerController.createLogger(ShowCellDetailCtrl.class);
    private final ResultTabProvider _resultTabProvider;
    private JToggleButton _button;

    public ShowCellDetailCtrl(ResultTab resultTab) {
        this._resultTabProvider = new ResultTabProvider(resultTab);
    }

    public JToggleButton getTabButton() {
        if (null == this._button) {
            this._button = GUIUtils.styleAsTabButton(new JToggleButton(Main.getApplication().getResources().getIcon("presentation")));
            this._button.setToolTipText(s_stringMgr.getString("ShowCellDetailCtrl.toggle.show.cellDetail.tooltip"));
            this._button.setSelected(ColumnDisplayUtil.isShowCellDetail());
            this._button.addActionListener(e -> this.onShowDetail());
        }
        return this._button;
    }

    private void onShowDetail() {
        ResultDataSetAndCellDetailDisplayHandler selectedTabsDisplayHandler = this._resultTabProvider.getResultTab().getSelectedResultTabsDisplayHandler();
        this._button.setEnabled(true);
        if (null == selectedTabsDisplayHandler) {
            CellDetailDisplayAvailableInfo.INFO_NO_DISPLAY_HANDLER.displayNotAvailableMessage();
            this._button.setSelected(false);
            return;
        }
        if (!selectedTabsDisplayHandler.getCellDetailDisplayAvailableInfo().isAvailable()) {
            selectedTabsDisplayHandler.getCellDetailDisplayAvailableInfo().displayNotAvailableMessage();
            this._button.setSelected(false);
            return;
        }
        selectedTabsDisplayHandler.setCellDetailVisible(this._button.isSelected());
    }

    public void finishedCreatingResultTab() {
        ResultDataSetAndCellDetailDisplayHandler selectedTabsDisplayHandler = this._resultTabProvider.getResultTab().getSelectedResultTabsDisplayHandler();
        if (null != selectedTabsDisplayHandler) {
            selectedTabsDisplayHandler.setCloseListener(() -> this.onClosedByPanelButton());
        }
    }

    private void onClosedByPanelButton() {
        if (this._button.isSelected()) {
            this._button.doClick();
        }
    }
}

