/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetFindPanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetFindPanelListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.EscapeAction;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindService;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindServiceCallBack;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindTrace;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.TableTraverser;
import net.sourceforge.squirrel_sql.fw.gui.EditableComboBoxHandler;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.colorrows.ColorSelectionCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow.RowsWindowFrame;
import net.sourceforge.squirrel_sql.fw.util.SquirrelConstants;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import org.apache.commons.lang3.StringUtils;

public class DataSetFindPanelController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataSetFindPanelController.class);
    private static final String PREF_KEY_DATASETFIND_TABLESEARCH_STRPREF_PREFIX = "SquirrelSQL.DataSetFind.tableSearch.StrPref_";
    private DataSetFindPanel _dataSetFindPanel;
    private EditableComboBoxHandler _editableComboBoxHandler;
    private TableTraverser _tableTraverser = new TableTraverser();
    private DataSetViewerTablePanel _dataSetViewerTablePanel;
    private FindService _findService;
    private Color _currentColor = SquirrelConstants.FIND_COLOR;
    private Color _traceColor = SquirrelConstants.FIND_COLOR_CURRENT;
    private FindTrace _trace = new FindTrace();
    private String _currentSearchString = null;

    public DataSetFindPanelController(DataSetFindPanelListener dataSetFindPanelListener, ISession session) {
        this._dataSetFindPanel = new DataSetFindPanel();
        this._dataSetFindPanel.btnDown.addActionListener(e -> this.onFind(FindMode.FORWARD));
        this._dataSetFindPanel.btnUp.addActionListener(e -> this.onFind(FindMode.BACKWARD));
        this._dataSetFindPanel.btnHighlightFindResult.addActionListener(e -> this.onFind(FindMode.HIGHLIGHT));
        this._dataSetFindPanel.btnUnhighlightResult.addActionListener(e -> this.clearFind());
        this._dataSetFindPanel.btnShowRowsFoundInTable.addActionListener(e -> this.onShowRowsFoundInTable(session));
        this._dataSetFindPanel.btnColorMatchedCells.addActionListener(e -> this.onColorMatchedCells());
        this._dataSetFindPanel.btnHideFindPanel.addActionListener(e -> dataSetFindPanelListener.hideFindPanel());
        this._dataSetFindPanel.chkCaseSensitive.addActionListener(e -> this.clearFind());
        this._dataSetFindPanel.cboMatchType.addItemListener(e -> this.clearFind());
        this._editableComboBoxHandler = new EditableComboBoxHandler(this._dataSetFindPanel.cboString, PREF_KEY_DATASETFIND_TABLESEARCH_STRPREF_PREFIX);
        this.initKeyStrokes();
    }

    private void onColorMatchedCells() {
        Color newColor;
        if (0 == this._trace.getCellsFound().size()) {
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("DataSetFindPanelController.noMatchesToColor"));
            return;
        }
        Color startColor = null;
        int rgb = ColorSelectionCommand.getPreviousColorRgb();
        if (rgb != -1) {
            startColor = new Color(rgb);
        }
        if (null == (newColor = JColorChooser.showDialog(GUIUtils.getOwningFrame(this._dataSetViewerTablePanel.getTable()), s_stringMgr.getString("DataSetFindPanel.colorMatchedCells"), startColor))) {
            return;
        }
        ColorSelectionCommand.setPreviousRowColorRgb(newColor);
        for (Point cell : this._trace.getCellsFound()) {
            Point buf = new Point();
            buf.x = cell.y;
            buf.y = this._dataSetViewerTablePanel.getTable().getSortableTableModel().transformToModelRow(cell.x);
            this._dataSetViewerTablePanel.getTable().getColoringService().getUserColorHandler().setColorForCell(buf, newColor);
        }
        this._dataSetFindPanel.btnUnhighlightResult.doClick(300);
        this._dataSetViewerTablePanel.getTable().repaint();
    }

    private void initKeyStrokes() {
        AbstractAction findNextAction = new AbstractAction("DataSetFind.FindNext"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.onFind(true);
            }
        };
        AbstractAction findPrevAction = new AbstractAction("DataSetFind.FindPrev"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this.onFind(false);
            }
        };
        AbstractAction unhighlightAction = new AbstractAction("DataSetFind.Unhighlight"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataSetFindPanelController.this._dataSetFindPanel.btnUnhighlightResult.doClick();
            }
        };
        EscapeAction escapeAction = new EscapeAction(this._dataSetFindPanel.btnUnhighlightResult, this._dataSetFindPanel.btnHideFindPanel);
        JComponent comp = (JComponent)this._dataSetFindPanel.cboString.getEditor().getEditorComponent();
        comp.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(10, 0, false), 0);
        comp.registerKeyboardAction(findNextAction, KeyStroke.getKeyStroke(114, 0, false), 0);
        comp.registerKeyboardAction(findPrevAction, KeyStroke.getKeyStroke(114, 64, false), 0);
        comp.registerKeyboardAction(escapeAction, KeyStroke.getKeyStroke(27, 0, false), 0);
    }

    private void onFind(boolean next) {
        if (next) {
            this._dataSetFindPanel.btnDown.doClick();
        } else {
            this._dataSetFindPanel.btnUp.doClick();
        }
    }

    private void onShowRowsFoundInTable(ISession session) {
        List<Object[]> allRows = this.ensureFindService().getRowsForViewIndexes(this._trace.getRowsFound());
        ColumnDisplayDefinition[] columnDisplayDefinitions = this.ensureFindService().getColumnDisplayDefinitions();
        RowsWindowFrame rowsWindowFrame = new RowsWindowFrame(SwingUtilities.windowForComponent(this._dataSetFindPanel), allRows, List.of(columnDisplayDefinitions), session);
        Main.getApplication().getRowsWindowFrameRegistry().add(rowsWindowFrame);
    }

    public void wasHidden() {
        this.clearFind();
    }

    private void clearFind() {
        this._trace.clear();
        this.ensureFindService();
        this._findService.repaintAll();
        this._tableTraverser.reset();
    }

    private void onFind(FindMode findMode) {
        this.checkDataSetViewerPanel();
        this.ensureFindService();
        String searchString = this._editableComboBoxHandler.getItem();
        if (!StringUtils.equals((CharSequence)searchString, (CharSequence)this._currentSearchString)) {
            this._trace.clear();
            this._findService.repaintAll();
            this._tableTraverser.reset();
        }
        this._currentSearchString = searchString;
        if (null == this._currentSearchString || !this._tableTraverser.hasRows() || StringUtilities.isEmpty(this._currentSearchString)) {
            return;
        }
        this._editableComboBoxHandler.addOrReplaceCurrentItem(this._currentSearchString);
        boolean matchFound = false;
        for (int i = 0; i < this._tableTraverser.getCellCount(); ++i) {
            if (FindMode.FORWARD == findMode || FindMode.HIGHLIGHT == findMode) {
                this._tableTraverser.forward();
            } else {
                this._tableTraverser.backward();
            }
            if (!this.matches(this._currentSearchString, this._findService.getViewDataAsString(this._tableTraverser.getRow(), this._tableTraverser.getCol()))) continue;
            matchFound = true;
            if (FindMode.HIGHLIGHT != findMode) {
                this._findService.scrollToVisible(this._tableTraverser.getRow(), this._tableTraverser.getCol());
            }
            this._findService.repaintCell(this._tableTraverser.getRow(), this._tableTraverser.getCol());
            if (null != this._trace.getCurrent()) {
                this._findService.repaintCell(this._trace.getCurrent().x, this._trace.getCurrent().y);
            }
            this._trace.add(this._tableTraverser.getRow(), this._tableTraverser.getCol());
            if (FindMode.HIGHLIGHT == findMode) continue;
            return;
        }
        if (!matchFound) {
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("DataSetFindPanelController.noOccurenceFoundOf", this._currentSearchString));
        }
    }

    private FindService ensureFindService() {
        if (null == this._findService) {
            this._findService = this._dataSetViewerTablePanel.createFindService();
            this._findService.setFindServiceCallBack(new FindServiceCallBack(){

                @Override
                public Color getBackgroundColor(int viewRow, int viewColumn) {
                    return DataSetFindPanelController.this.onGetBackgroundColor(viewRow, viewColumn);
                }

                @Override
                public void tableCellStructureChanged() {
                    DataSetFindPanelController.this.clearFind();
                }
            });
            this._tableTraverser.setFindService(this._findService);
        }
        return this._findService;
    }

    private void checkDataSetViewerPanel() {
        if (null == this._dataSetViewerTablePanel) {
            throw new IllegalStateException("Find panel should not be visible when _dataSetViewerTablePanel is null");
        }
    }

    private boolean matches(String toMatchAgainst, String viewDataAsString) {
        DataSetFindPanel.MatchTypeCboItem sel = (DataSetFindPanel.MatchTypeCboItem)((Object)this._dataSetFindPanel.cboMatchType.getSelectedItem());
        if (!this._dataSetFindPanel.chkCaseSensitive.isSelected()) {
            if (DataSetFindPanel.MatchTypeCboItem.REG_EX != sel) {
                toMatchAgainst = toMatchAgainst.toLowerCase();
            }
            viewDataAsString = viewDataAsString.toLowerCase();
        }
        switch (sel) {
            case CONTAINS: {
                return viewDataAsString.contains(toMatchAgainst);
            }
            case EXACT: {
                return viewDataAsString.equals(toMatchAgainst);
            }
            case STARTS_WITH: {
                return viewDataAsString.startsWith(toMatchAgainst);
            }
            case ENDS_WITH: {
                return viewDataAsString.endsWith(toMatchAgainst);
            }
            case REG_EX: {
                return viewDataAsString.matches(toMatchAgainst);
            }
        }
        throw new IllegalArgumentException("Unknown match type " + sel);
    }

    public DataSetFindPanel getPanel() {
        return this._dataSetFindPanel;
    }

    public void setDataSetViewerTablePanel(DataSetViewerTablePanel dataSetViewerTablePanel) {
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this.reset();
    }

    public void reset() {
        this._findService = null;
        this._trace.clear();
    }

    private Color onGetBackgroundColor(int viewRow, int viewColumn) {
        String searchString = this._editableComboBoxHandler.getItem();
        if (null == searchString) {
            return null;
        }
        if (this._trace.contains(viewRow, viewColumn)) {
            if (this._trace.isCurrent(viewRow, viewColumn)) {
                return this._currentColor;
            }
            return this._traceColor;
        }
        return null;
    }

    public void focusTextField() {
        this._editableComboBoxHandler.focus();
    }

    private static enum FindMode {
        FORWARD,
        BACKWARD,
        HIGHLIGHT;

    }
}

