/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ResultDataSetAndCellDetailDisplayHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.columndisplaychoice.ResultTableType;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DataSetFindPanelController;

public class DataSetViewerFindHandler {
    private ResultDataSetAndCellDetailDisplayHandler _resultDisplayHandler;
    private ISession _session;
    private Window _parent;
    private final JPanel _pnlFindResultCompound;
    private boolean _findPanelOpen;
    private DataSetFindPanelController _dataSetFindPanelController;

    public DataSetViewerFindHandler(IDataSetViewer dataSetViewer, ISession session, ResultTableType resultTableType) {
        this(dataSetViewer, session, resultTableType, null);
    }

    public DataSetViewerFindHandler(IDataSetViewer dataSetViewer, ISession session, ResultTableType resultTableType, Window parent) {
        this._resultDisplayHandler = new ResultDataSetAndCellDetailDisplayHandler(dataSetViewer, resultTableType);
        this._session = session;
        this._parent = parent;
        this._pnlFindResultCompound = new JPanel(new BorderLayout());
        this._dataSetFindPanelController = new DataSetFindPanelController(() -> this.toggleShowFindPanel(), session);
        if (this._resultDisplayHandler.isDataSetViewerTablePanel()) {
            this._dataSetFindPanelController.setDataSetViewerTablePanel(this._resultDisplayHandler.getDataSetViewerTablePanel());
        }
        this._pnlFindResultCompound.add((Component)this._resultDisplayHandler.getComponent(), "Center");
    }

    public Component getComponent() {
        return this._pnlFindResultCompound;
    }

    public boolean toggleShowFindPanel() {
        if (!this._resultDisplayHandler.isDataSetViewerTablePanel()) {
            return false;
        }
        boolean bl = this._findPanelOpen = !this._findPanelOpen;
        if (this._findPanelOpen) {
            this._pnlFindResultCompound.add((Component)this._dataSetFindPanelController.getPanel(), "North");
            this._pnlFindResultCompound.revalidate();
            this._dataSetFindPanelController.focusTextField();
        } else {
            this._pnlFindResultCompound.remove(this._dataSetFindPanelController.getPanel());
            this._dataSetFindPanelController.wasHidden();
            this._pnlFindResultCompound.revalidate();
            if (null == this._parent) {
                ISQLPanelAPI sqlPanelAPI = this._session.getSQLPanelAPIOfActiveSessionWindow(true);
                if (null != sqlPanelAPI) {
                    sqlPanelAPI.getSQLEntryPanel().requestFocus();
                }
            } else {
                this._parent.requestFocus();
            }
        }
        return true;
    }

    public IDataSetViewer replaceDataSetViewer(IDataSetViewer dataSetViewer) {
        IDataSetViewer previousDataSetViewer = this._resultDisplayHandler.replaceDataSetViewer(dataSetViewer);
        if (this._resultDisplayHandler.isDataSetViewerTablePanel()) {
            this._dataSetFindPanelController.setDataSetViewerTablePanel(this._resultDisplayHandler.getDataSetViewerTablePanel());
        } else {
            this._dataSetFindPanelController.setDataSetViewerTablePanel(null);
        }
        return previousDataSetViewer;
    }

    public void resetFind() {
        this._dataSetFindPanelController.reset();
    }

    public IDataSetViewer getDataSetViewer() {
        return this._resultDisplayHandler.getDataSetViewer();
    }

    public void setParentWindow(Window parent) {
        this._parent = parent;
    }

    public void clearParentWindow() {
        this._parent = null;
    }

    public ResultDataSetAndCellDetailDisplayHandler getResultDisplayHandler() {
        return this._resultDisplayHandler;
    }

    private static class NullPanel
    extends JPanel {
        private NullPanel() {
            this.setPreferredSize(new Dimension(0, 0));
            this.setSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
    }
}

