/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset;

import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.DataSetTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.ResultAsText;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.ResultAsTextLineCallback;

public class DataSetTextAreaController {
    private DataSetTextArea _outText = new DataSetTextArea();
    private ResultAsText _resultAsText;

    public void init(ColumnDisplayDefinition[] colDefs, boolean showHeadings) {
        ResultAsTextLineCallback resultAsTextLineCallback = line -> this._outText.append(line);
        this._resultAsText = new ResultAsText(colDefs, showHeadings, this.isShowRowNumberInTextLayout(), resultAsTextLineCallback);
    }

    private boolean isShowRowNumberInTextLayout() {
        boolean showRowNumberInTextLayout = Main.getApplication().getSquirrelPreferences().getSessionProperties().getShowRowNumberInTextLayout();
        ISession activeSession = Main.getApplication().getSessionManager().getActiveSession();
        if (null != activeSession) {
            showRowNumberInTextLayout = activeSession.getProperties().getShowRowNumberInTextLayout();
        }
        return showRowNumberInTextLayout;
    }

    public void clear() {
        this._outText.setText("");
        if (null != this._resultAsText) {
            this._resultAsText.clear();
        }
    }

    public void addRow(Object[] row) {
        this._resultAsText.addRow(row);
    }

    public void close() {
        this._resultAsText.close();
    }

    public void moveToTop() {
        this._outText.select(0, 0);
    }

    public JComponent getComponent() {
        return this._outText;
    }

    public int getRowCount() {
        if (null == this._resultAsText) {
            return 0;
        }
        return this._resultAsText.getRowCount();
    }
}

