/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset;

import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.ResultAsTextLineCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.CellStyle;
import org.nocrala.tools.texttablefmt.ShownBorders;
import org.nocrala.tools.texttablefmt.Table;

public class ResultAsText {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultAsText.class);
    private static final int MAX_CELL_WIDTH = 1000000;
    private ColumnDisplayDefinition[] _colDefs;
    private int _rowCount = 0;
    private ResultAsTextLineCallback _resultAsTextLineCallback;
    private Table _table;
    private CellStyle[] _cellStyles;
    private String _text;
    private boolean _showRowNumbers;
    private CellStyle LEFT_ALIGN = new CellStyle(CellStyle.HorizontalAlign.LEFT, CellStyle.AbbreviationStyle.CROP, CellStyle.NullStyle.NULL_TEXT, false);
    private CellStyle CENTER_ALIGN = new CellStyle(CellStyle.HorizontalAlign.CENTER, CellStyle.AbbreviationStyle.CROP, CellStyle.NullStyle.NULL_TEXT, false);
    private CellStyle RIGHT_ALIGN = new CellStyle(CellStyle.HorizontalAlign.RIGHT, CellStyle.AbbreviationStyle.CROP, CellStyle.NullStyle.NULL_TEXT, false);

    public ResultAsText(ColumnDisplayDefinition[] colDefs, boolean showHeadings, ResultAsTextLineCallback resultAsTextLineCallback) {
        this(colDefs, showHeadings, false, resultAsTextLineCallback);
    }

    public ResultAsText(ColumnDisplayDefinition[] colDefs, boolean showHeadings, boolean showRowNumbers, ResultAsTextLineCallback resultAsTextLineCallback) {
        int i;
        this._colDefs = colDefs;
        this._rowCount = 0;
        this._showRowNumbers = showRowNumbers;
        this._resultAsTextLineCallback = resultAsTextLineCallback;
        this._cellStyles = new CellStyle[this._colDefs.length];
        for (i = 0; i < this._colDefs.length; ++i) {
            this._cellStyles[i] = this.getCellStyle(colDefs[i]);
        }
        if (showHeadings) {
            if (this._showRowNumbers) {
                this._table = new Table(this._colDefs.length + 1, BorderStyle.DESIGN_FORMAL_WIDE, ShownBorders.HEADER_AND_COLUMNS);
                this._table.addCell(s_stringMgr.getString("ResultAsText.rowNumber"), this.RIGHT_ALIGN);
            } else {
                this._table = new Table(this._colDefs.length, BorderStyle.DESIGN_FORMAL_WIDE, ShownBorders.HEADER_AND_COLUMNS);
            }
            for (i = 0; i < this._colDefs.length; ++i) {
                this._table.addCell(colDefs[i].getColumnHeading(), this._cellStyles[i]);
            }
        } else {
            this._table = this._showRowNumbers ? new Table(this._colDefs.length + 1, BorderStyle.DESIGN_FORMAL_WIDE, ShownBorders.NONE) : new Table(this._colDefs.length, BorderStyle.DESIGN_FORMAL_WIDE, ShownBorders.NONE);
        }
        for (i = 0; i < this._colDefs.length; ++i) {
            this._table.setColumnWidth(i, 1, 1000000);
        }
    }

    public void addRow(Object[] row) {
        ++this._rowCount;
        if (this._showRowNumbers) {
            this._table.addCell(Integer.toString(this._rowCount), this.RIGHT_ALIGN);
        }
        for (int i = 0; i < this._colDefs.length; ++i) {
            String cellValue = CellComponentFactory.renderObject(row[i], this._colDefs[i]);
            this._table.addCell(cellValue, this._cellStyles[i]);
        }
    }

    public void clear() {
        this._rowCount = 0;
        this._text = null;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public String getText() {
        this.close();
        return "n/a";
    }

    public void close() {
        if (this._text == null) {
            this._text = this._table.render();
        }
        this._resultAsTextLineCallback.addLine(this._text);
    }

    private CellStyle getCellStyle(ColumnDisplayDefinition def) {
        if (def.getSqlType() == -5 || def.getSqlType() == -7 || def.getSqlType() == 3 || def.getSqlType() == 8 || def.getSqlType() == 6 || def.getSqlType() == 4 || def.getSqlType() == 2 || def.getSqlType() == 7 || def.getSqlType() == 5 || def.getSqlType() == -6) {
            return this.RIGHT_ALIGN;
        }
        if (def.getSqlType() == 91 || def.getSqlType() == 92 || def.getSqlType() == 93 || def.getSqlType() == 2013 || def.getSqlType() == 2014) {
            return this.CENTER_ALIGN;
        }
        return this.LEFT_ALIGN;
    }
}

