/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SequencePropertyMutability;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.StringTemplateConstants;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.HibernateException;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;

public abstract class CommonHibernateDialect
implements HibernateDialect,
StringTemplateConstants {
    protected String DROP_COLUMN_SQL_TEMPLATE = "ALTER TABLE $tableName$ DROP $columnName$ $cascade$";

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        return true;
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 21;
        String msg = DialectUtils.getUnsupportedMessage(this, 21);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return this.getAddAutoIncrementSQL(column, qualifier, prefs);
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = false;
        boolean addNullClause = true;
        String sql = DialectUtils.getAddColumSQL(column, this, true, false, true, qualifier, prefs);
        return new String[]{sql};
    }

    @Override
    public String getAddColumnString() {
        return "ADD";
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 19;
        String msg = DialectUtils.getUnsupportedMessage(this, 19);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] colInfos, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{DialectUtils.getAddPrimaryKeySQL(ti, pkName, colInfos, false, qualifier, prefs, this)};
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 20;
        String msg = DialectUtils.getUnsupportedMessage(this, 20);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 16;
        String msg = DialectUtils.getUnsupportedMessage(this, 16);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        boolean featureId = false;
        String msg = DialectUtils.getUnsupportedMessage(this, 0);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean featureId = true;
        String msg = DialectUtils.getUnsupportedMessage(this, 1);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        StringTemplate st = new StringTemplate(this.DROP_COLUMN_SQL_TEMPLATE);
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", tableName, "columnName", columnName);
        String dropSql = DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
        return DialectUtils.stripQuotesFromIdentifier(this, columnName, dropSql);
    }

    @Override
    public int getColumnLength(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 3;
        String msg = DialectUtils.getUnsupportedMessage(this, 3);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 4;
        String msg = DialectUtils.getUnsupportedMessage(this, 4);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        int featureId = 5;
        String msg = DialectUtils.getUnsupportedMessage(this, 5);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 13;
        String msg = DialectUtils.getUnsupportedMessage(this, 13);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 15;
        String msg = DialectUtils.getUnsupportedMessage(this, 15);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc, boolean sortColumns) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc, sortColumns);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public String getCreateTableSQL(String tableName, List<TableColumnInfo> columns, List<TableColumnInfo> primaryKeys, SqlGenerationPreferences prefs, DatabaseObjectQualifier qualifier) {
        return DialectUtils.getCreateTableSQL(tableName, columns, primaryKeys, prefs, qualifier, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 10;
        String msg = DialectUtils.getUnsupportedMessage(this, 10);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDisplayName() {
        return "Generic";
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 22;
        String msg = DialectUtils.getUnsupportedMessage(this, 22);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP INDEX $indexName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("indexName", indexName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 7;
        String msg = DialectUtils.getUnsupportedMessage(this, 7);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 18;
        String msg = DialectUtils.getUnsupportedMessage(this, 18);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropViewSQL(viewName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return null;
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    public String getInsertIntoSQL(String tableName, List<String> columns, String valuesPart, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getInsertIntoSQL(tableName, columns, valuesPart, qualifier, prefs, this);
    }

    @Override
    public String getLengthFunction(int dataType) {
        return "length";
    }

    @Override
    public String getMaxFunction() {
        return "max";
    }

    @Override
    public int getMaxPrecision(int dataType) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxScale(int dataType) {
        return this.getMaxPrecision(dataType);
    }

    @Override
    public String getNullColumnString() {
        return "";
    }

    @Override
    public int getPrecisionDigits(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return identifier;
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 9;
        String msg = DialectUtils.getUnsupportedMessage(this, 9);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 11;
        String msg = DialectUtils.getUnsupportedMessage(this, 11);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 17;
        String msg = DialectUtils.getUnsupportedMessage(this, 17);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo tableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(tableInfo, true, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String getTypeName(TableColumnInfo tcInfo) {
        int columnSize = tcInfo.getColumnSize();
        int dataType = tcInfo.getDataType();
        int precision = this.getPrecisionDigits(columnSize, dataType);
        if (dataType == 1111) {
            dataType = this.getJavaTypeForNativeType(tcInfo.getTypeName());
        }
        return this.getTypeName(dataType, columnSize, precision, tcInfo.getDecimalDigits(), tcInfo.getTypeName());
    }

    @Override
    public int getJavaTypeForNativeType(String nativeColumnTypeName) {
        throw new IllegalStateException("Dialect (" + this.getDisplayName() + ") doesn't provide a java type for native type = " + nativeColumnTypeName);
    }

    @Override
    public String getTypeName(int code) throws HibernateException {
        throw new UnsupportedOperationException("Common dialect doesn't register column types");
    }

    @Override
    public String[] getUpdateSQL(String tableName, String[] setColumns, String[] setValues, String[] fromTables, String[] whereColumns, String[] whereValues, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "";
        templateStr = fromTables != null ? "UPDATE $destTableName$ dest SET $columnName$ = (SELECT src.$columnName$ FROM $sourceTableName$ src where src.$whereColumnName$ = dest.$whereValue$)" : "UPDATE $destTableName$ SET $columnName$ = $columnValue$ where $whereColumnName$ = $whereValue$";
        StringTemplate st = new StringTemplate(templateStr);
        return DialectUtils.getUpdateSQL(st, tableName, setColumns, setValues, fromTables, whereColumns, whereValues, qualifier, prefs, this);
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 25;
        String msg = DialectUtils.getUnsupportedMessage(this, 25);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return false;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return false;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return false;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public boolean supportsCreateIndex() {
        return false;
    }

    @Override
    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return false;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return false;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return false;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        return false;
    }

    @Override
    public boolean supportsRenameColumn() {
        return false;
    }

    @Override
    public boolean supportsRenameTable() {
        return false;
    }

    @Override
    public boolean supportsRenameView() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return true;
    }

    @Override
    public boolean supportsSequence() {
        return false;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return false;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return false;
    }

    @Override
    public char closeQuote() {
        return '\"';
    }

    @Override
    public char openQuote() {
        return '\"';
    }

    @Override
    public SequencePropertyMutability getSequencePropertyMutability() {
        return new SequencePropertyMutability();
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return true;
    }

    @Override
    public boolean supportsAddPrimaryKey() {
        return true;
    }

    @Override
    public boolean supportsDropPrimaryKey() {
        return true;
    }

    @Override
    public int getTimestampMaximumFractionalDigits() {
        return 3;
    }

    @Override
    public String getBinaryLiteralString(byte[] binaryData) {
        StringBuilder result = new StringBuilder();
        result.append("'").append(DialectUtils.toHexString(binaryData)).append("'");
        return result.toString();
    }

    @Override
    public String getTypeName(int javaSqlTypesConst, int length, int precision, int scale) throws HibernateException {
        return this.getTypeName(javaSqlTypesConst, length, precision, scale, null);
    }
}

