/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.HibernateException;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.dialect.Dialect;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;

public class DaffodilDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private final DaffodilDialectHelper _dialect = new DaffodilDialectHelper();

    @Override
    public String getTypeName(int javaSqlTypesConst, int length, int precision, int scale, String typeNameOrNull) throws HibernateException {
        return this._dialect.getTypeName(javaSqlTypesConst, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        boolean result = true;
        DatabaseObjectType type = info.getDatabaseObjectType();
        if (type.getName().equalsIgnoreCase("database")) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return false;
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 6) {
            return 15;
        }
        if (dataType == 2 || dataType == 3) {
            return 38;
        }
        return 0;
    }

    @Override
    public String getDisplayName() {
        return "Daffodil";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("Daffodil");
    }

    @Override
    public String getAddColumnString() {
        return "ADD COLUMN";
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(tableName);
        result.append(" DROP COLUMN ");
        result.append(columnName);
        result.append(" CASCADE");
        return result.toString();
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, true, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{DialectUtils.getAddPrimaryKeySQL(ti, pkName, columns, false, qualifier, prefs, this)};
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        boolean featureId = false;
        String msg = DialectUtils.getUnsupportedMessage(this, 0);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return false;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 4;
        String msg = DialectUtils.getUnsupportedMessage(this, 4);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsRenameColumn() {
        return false;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 3;
        String msg = DialectUtils.getUnsupportedMessage(this, 3);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        int featureId = 5;
        String msg = DialectUtils.getUnsupportedMessage(this, 5);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "ALTER COLUMN";
        String defaultClause = "SET DEFAULT";
        return DialectUtils.getColumnDefaultAlterSQL(this, info, "ALTER COLUMN", false, "SET DEFAULT", qualifier, prefs);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, true, true, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.DAFFODIL;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return null;
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 21;
        String msg = DialectUtils.getUnsupportedMessage(this, 21);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean deferrableNotSupported = null;
        Boolean initiallyDeferredNotSupported = null;
        Boolean matchFullNotSupported = null;
        return DialectUtils.getAddForeignKeyConstraintSQL(localTableName, refTableName, constraintName, deferrableNotSupported, initiallyDeferredNotSupported, matchFullNotSupported, autoFKIndex, fkIndexName, localRefColumns, onUpdateAction, onDeleteAction, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "ALTER TABLE $tableName$ ADD CONSTRAINT $constraintName$ UNIQUE ($columnName;  separator=\",\"$)";
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ADD CONSTRAINT $constraintName$ UNIQUE ($columnName;  separator=\",\"$)");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("tableName", tableName, "constraintName", constraintName);
        return new String[]{DialectUtils.getAddUniqueConstraintSQL(st, valuesMap, columns, qualifier, prefs, (HibernateDialect)this)};
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getSimulatedAlterSequenceSQL(sequenceName, increment, minimum, maximum, minimum, cache, cycle, qualifier, prefs, this);
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("CREATE ");
        result.append(" INDEX ");
        result.append(DialectUtils.shapeQualifiableIdentifier(indexName, qualifier, prefs, this));
        result.append(" ON ");
        result.append(DialectUtils.shapeQualifiableIdentifier(tableName, qualifier, prefs, this));
        result.append("(");
        for (String column : columns) {
            result.append(column);
            result.append(",");
        }
        result.setLength(result.length() - 1);
        result.append(")");
        return result.toString();
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getCreateSequenceSQL(sequenceName, increment, minimum, maximum, start, cache, null, qualifier, prefs, this);
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = false;
        boolean addNullClause = true;
        return new String[]{DialectUtils.getAddColumSQL(column, this, true, false, true, qualifier, prefs)};
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getCreateViewSQL(viewName, definition, checkOption, qualifier, prefs, this);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 22;
        String msg = DialectUtils.getUnsupportedMessage(this, 22);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 14;
        String msg = DialectUtils.getUnsupportedMessage(this, 14);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 9;
        String msg = DialectUtils.getUnsupportedMessage(this, 9);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 17;
        String msg = DialectUtils.getUnsupportedMessage(this, 17);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return false;
    }

    @Override
    public boolean supportsDropIndex() {
        return false;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return true;
    }

    @Override
    public boolean supportsRenameTable() {
        return false;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return false;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String schema = qualifier.getSchema();
        String catalog = qualifier.getCatalog();
        StringBuilder result = new StringBuilder();
        if (catalog != null) {
            result.append(DialectUtils.shapeIdentifier(catalog, prefs, this));
            result.append(".");
        }
        if (schema != null) {
            result.append(DialectUtils.shapeIdentifier(schema, prefs, this));
            result.append(".");
        }
        result.append(DialectUtils.shapeIdentifier(identifier, prefs, this));
        return result.toString();
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public boolean supportsSubSecondTimestamps() {
        return false;
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropViewSQL(viewName, cascade, qualifier, prefs, this);
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP SEQUENCE $sequenceName$ $cascade$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("sequenceName", sequenceName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    private class DaffodilDialectHelper
    extends Dialect {
        public DaffodilDialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, 4192, "binary($l)");
            this.registerColumnType(-2, 0x3FFFFFFF, "long varbinary($l)");
            this.registerColumnType(-2, "long varbinary(1073741823)");
            this.registerColumnType(-7, "bit");
            this.registerColumnType(2004, 0x3FFFFFFF, "blob($l)");
            this.registerColumnType(2004, "blob(1073741823)");
            this.registerColumnType(16, "boolean");
            this.registerColumnType(1, 4192, "char($l)");
            this.registerColumnType(1, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(1, "clob(1073741823)");
            this.registerColumnType(2005, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(2005, "clob(1073741823)");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p,$s)");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "integer");
            this.registerColumnType(-4, 0x3FFFFFFF, "long varbinary($l)");
            this.registerColumnType(-4, "long varbinary(1073741823)");
            this.registerColumnType(-1, 0x3FFFFFFF, "long varchar($l)");
            this.registerColumnType(-1, "long varchar(1073741823)");
            this.registerColumnType(2, "numeric($p,$s)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, 4192, "varbinary($l)");
            this.registerColumnType(-3, 0x3FFFFFFF, "long varbinary($l)");
            this.registerColumnType(-3, "long varbinary(1073741823)");
            this.registerColumnType(12, 4192, "varchar($l)");
            this.registerColumnType(12, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(12, "clob(1073741823)");
            this.registerColumnType(-8, "integer");
            this.registerColumnType(-9, 4192, "varchar($l)");
            this.registerColumnType(-9, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(-9, "clob(1073741823)");
            this.registerColumnType(-15, 4192, "char($l)");
            this.registerColumnType(-15, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(-15, "clob(1073741823)");
            this.registerColumnType(-16, 0x3FFFFFFF, "long varchar($l)");
            this.registerColumnType(-16, "long varchar(1073741823)");
            this.registerColumnType(2009, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(2009, "clob(1073741823)");
            this.registerColumnType(2011, 0x3FFFFFFF, "clob($l)");
            this.registerColumnType(2011, "clob(1073741823)");
        }
    }
}

