/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SequencePropertyMutability;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.HibernateException;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.dialect.PostgreSQLDialect;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;

public class GreenplumDialectExt
extends CommonHibernateDialect {
    private GreenplumDialectHelper _dialect = new GreenplumDialectHelper();
    private String cascadeClause;

    @Override
    public DialectType getDialectType() {
        return DialectType.NETEZZA;
    }

    @Override
    public String getDisplayName() {
        return "Greenplum";
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP SEQUENCE $sequenceName$ $cascade$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("sequenceName", sequenceName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public int getMaxPrecision(int dataType) {
        return 38;
    }

    @Override
    public int getMaxScale(int dataType) {
        return 38;
    }

    @Override
    public int getPrecisionDigits(int columnSize, int dataType) {
        return columnSize;
    }

    @Override
    public String getTypeName(int javaSqlTypesConst, int length, int precision, int scale, String typeNameOrNull) throws HibernateException {
        return this._dialect.getTypeName(javaSqlTypesConst, length, precision, scale);
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return false;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return false;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    @Override
    public boolean supportsCreateIndex() {
        return false;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropColumn() {
        return false;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return false;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return -1 < databaseProductName.trim().toUpperCase().indexOf("GREEN") && -1 < databaseProductName.trim().toUpperCase().indexOf("PLUM") || -1 < databaseProductVersion.trim().toUpperCase().indexOf("GREEN") && -1 < databaseProductVersion.trim().toUpperCase().indexOf("PLUM");
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public boolean supportsRenameTable() {
        return true;
    }

    @Override
    public boolean supportsRenameView() {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return true;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return false;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo tableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean supportsCascade = false;
        boolean supportsMatViews = true;
        return DialectUtils.getTableDropSQL(tableInfo, false, cascadeConstraints, true, this.cascadeClause, isMaterializedView, qualifier, prefs, this);
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(DialectUtils.getUnsupportedMessage(this, 2));
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        throw new UnsupportedOperationException(DialectUtils.getUnsupportedMessage(this, 13));
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        throw new UnsupportedOperationException(DialectUtils.getUnsupportedMessage(this, 14));
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        throw new UnsupportedOperationException(DialectUtils.getUnsupportedMessage(this, 26));
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        throw new UnsupportedOperationException(DialectUtils.getUnsupportedMessage(this, 4));
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(DialectUtils.getUnsupportedMessage(this, 5));
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "ALTER COLUMN";
        boolean specifyType = false;
        String defaultClause = "SET DEFAULT";
        return DialectUtils.getColumnDefaultAlterSQL(this, info, alterClause, specifyType, defaultClause, qualifier, prefs);
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "RENAME COLUMN";
        String renameToClause = "TO";
        return DialectUtils.getColumnNameAlterSQL(from, to, alterClause, renameToClause, qualifier, prefs, this);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getRenameTableSQL(oldTableName, newTableName, qualifier, prefs, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getCreateViewSQL(viewName, definition, checkOption, qualifier, prefs, this);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String commandPrefix = "ALTER VIEW";
        String renameClause = "RENAME TO";
        return new String[]{DialectUtils.getRenameViewSQL(commandPrefix, renameClause, oldViewName, newViewName, qualifier, prefs, this)};
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return "SELECT 'create or replace view ' || v.VIEWNAME || ' as ' || v.definition FROM _v_view v, _v_objs_owned o where v.objid = o.objid and o.DATABASE = '" + qualifier.getCatalog() + "' and v.VIEWNAME = '" + viewName + "'";
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String minimumClause = "MINVALUE";
        String maximumClause = "MAXVALUE";
        String cycleClause = "CYCLE";
        if (!cycle) {
            cycleClause = "NO CYCLE";
        }
        return DialectUtils.getCreateSequenceSQL(sequenceName, increment, "MINVALUE", minimum, "MAXVALUE", maximum, start, cache, cycleClause, qualifier, prefs, this);
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String cycleClause = "CYCLE";
        if (!cycle) {
            cycleClause = "NO CYCLE";
        }
        return new String[]{DialectUtils.getAlterSequenceSQL(sequenceName, increment, minimum, maximum, restart, cache, cycleClause, qualifier, prefs, this)};
    }

    @Override
    public SequencePropertyMutability getSequencePropertyMutability() {
        SequencePropertyMutability result = new SequencePropertyMutability();
        result.setCache(false);
        return result;
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getAddForeignKeyConstraintSQL(localTableName, refTableName, constraintName, deferrable, initiallyDeferred, matchFull, autoFKIndex, fkIndexName, localRefColumns, onUpdateAction, onDeleteAction, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{DialectUtils.getAddUniqueConstraintSQL(tableName, constraintName, columns, qualifier, prefs, (HibernateDialect)this)};
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropConstraintSQL(tableName, constraintName, qualifier, prefs, this) + " RESTRICT";
    }

    private class GreenplumDialectHelper
    extends PostgreSQLDialect {
        public GreenplumDialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-7, "bool");
            this.registerColumnType(16, "bool");
            this.registerColumnType(1, 64000, "char($l)");
            this.registerColumnType(1, "char(64000)");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p,2)");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(6, 15, "float($p)");
            this.registerColumnType(6, "float(15)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-1, "char(64000)");
            this.registerColumnType(2, "numeric($p,$s)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "byteint");
            this.registerColumnType(12, 64000, "varchar($l)");
            this.registerColumnType(12, "varchar(64000)");
        }
    }
}

