/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.OptionalSqlClause;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.HibernateException;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.dialect.SAPDBDialect;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;

public class MAXDBDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private final MAXDBDialectHelper _dialect = new MAXDBDialectHelper();

    @Override
    public String getTypeName(int javaSqlTypesConst, int length, int precision, int scale, String typeNameOrNull) throws HibernateException {
        return this._dialect.getTypeName(javaSqlTypesConst, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        boolean result = true;
        DatabaseObjectType type = info.getDatabaseObjectType();
        if (type.getName().equalsIgnoreCase("database")) {
            result = false;
        }
        return result;
    }

    @Override
    public int getMaxPrecision(int dataType) {
        return 38;
    }

    @Override
    public int getPrecisionDigits(int columnSize, int dataType) {
        return columnSize * 2;
    }

    @Override
    public int getColumnLength(int columnSize, int dataType) {
        if (dataType == -4) {
            return Integer.MAX_VALUE;
        }
        return columnSize;
    }

    @Override
    public String getDisplayName() {
        return "MaxDB";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        String lname = databaseProductName.trim().toLowerCase();
        return lname.startsWith("sap") || lname.startsWith("maxdb");
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnDropSQL(tableName, columnName, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, true, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        for (TableColumnInfo info : columns) {
            result.add(this.getColumnNullableAlterSQL(info, false));
        }
        result.add(DialectUtils.getAddPrimaryKeySQL(ti, pkName, columns, false, qualifier, prefs, this));
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        return DialectUtils.getColumnCommentAlterSQL(info, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        boolean nullable = info.isNullable().equalsIgnoreCase("YES");
        return new String[]{this.getColumnNullableAlterSQL(info, nullable)};
    }

    public String getColumnNullableAlterSQL(TableColumnInfo info, boolean nullable) {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(info.getTableName());
        result.append(" COLUMN ");
        result.append(info.getColumnName());
        if (nullable) {
            result.append(" DEFAULT NULL");
        } else {
            result.append(" NOT NULL");
        }
        return result.toString();
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnRenameSQL(from, to, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        String alterClause = "MODIFY";
        return DialectUtils.getColumnTypeAlterSQL(this, "MODIFY", "", false, from, to, qualifier, prefs);
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "COLUMN";
        String newDefault = info.getDefaultValue();
        String defaultClause = null;
        defaultClause = newDefault != null && !"".equals(newDefault) ? "ADD DEFAULT" : "DROP DEFAULT";
        return DialectUtils.getColumnDefaultAlterSQL(this, info, "COLUMN", false, defaultClause, qualifier, prefs);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, false, false, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.MAXDB;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return null;
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 21;
        String msg = DialectUtils.getUnsupportedMessage(this, 21);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = false;
        boolean addNullClause = true;
        String sql = DialectUtils.getAddColumSQL(column, this, true, false, true, qualifier, prefs);
        result.add(sql);
        if (column.getRemarks() != null && !"".equals(column.getRemarks())) {
            result.add(this.getColumnCommentAlterSQL(column, qualifier, prefs));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate fkST = new StringTemplate("ALTER TABLE $childTableName$ ADD $constraint$ $constraintName$ FOREIGN KEY ( $childColumn; separator=\",\"$ ) REFERENCES $parentTableName$ ( $parentColumn; separator=\",\"$ )");
        HashMap<String, String> fkValuesMap = DialectUtils.getValuesMap("childTableName", localTableName);
        fkValuesMap.put("constraint", "CONSTRAINT");
        fkValuesMap.put("constraintName", constraintName);
        fkValuesMap.put("parentTableName", refTableName);
        StringTemplate childIndexST = null;
        HashMap<String, String> ckIndexValuesMap = null;
        if (autoFKIndex) {
            childIndexST = new StringTemplate("CREATE $unique$ $storageOption$ INDEX $indexName$ ON $tableName$ ( $columnName; separator=\",\"$ )");
            ckIndexValuesMap = new HashMap<String, String>();
            ckIndexValuesMap.put("indexName", "fk_child_idx");
        }
        return DialectUtils.getAddForeignKeyConstraintSQL(fkST, fkValuesMap, childIndexST, ckIndexValuesMap, localRefColumns, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 20;
        String msg = DialectUtils.getUnsupportedMessage(this, 20);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getSimulatedAlterSequenceSQL(sequenceName, increment, minimum, maximum, minimum, cache, cycle, qualifier, prefs, this);
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE $unique$ $storageOption$ INDEX $indexName$ ON $tableName$ ( $columnName; separator=\",\"$ )");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        if (unique) {
            valuesMap.put("unique", "UNIQUE");
            if (accessMethod != null && "HASH".equalsIgnoreCase(accessMethod)) {
                valuesMap.put("storageOption", "HASH");
            }
        }
        valuesMap.put("indexName", indexName);
        valuesMap.put("tableName", tableName);
        return DialectUtils.getAddIndexSQL(this, st, valuesMap, columns, qualifier, prefs);
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE SEQUENCE $sequenceName$ $startWith$ $increment$ $minimum$ $maximum$ $cache$ $cycle$");
        OptionalSqlClause incClause = new OptionalSqlClause("INCREMENT BY", increment);
        OptionalSqlClause minClause = new OptionalSqlClause("MINVALUE", minimum);
        OptionalSqlClause maxClause = new OptionalSqlClause("MAXVALUE", maximum);
        OptionalSqlClause cacheClause = new OptionalSqlClause("CACHE", cache);
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("sequenceName", sequenceName, "increment", incClause, "minimum", minClause, "maximum", maxClause, "cache", cacheClause);
        if (cycle) {
            valuesMap.put("cycle", "CYCLE");
        }
        return DialectUtils.getCreateSequenceSQL(st, valuesMap, qualifier, prefs, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE VIEW $viewName$ AS $selectStatement$ $withCheckOption$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("viewName", viewName, "selectStatement", definition);
        if (checkOption != null && !"".equals(checkOption)) {
            valuesMap.put("withcheckOption", "WITH CHECK OPTION");
        }
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 22;
        String msg = DialectUtils.getUnsupportedMessage(this, 22);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP INDEX $indexName$ ON $tableName$");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("indexName", indexName);
        valuesMap.put("tableName", tableName);
        return DialectUtils.bindAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP SEQUENCE $sequenceName$ $cascade$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("sequenceName", sequenceName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP VIEW $viewName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("viewName", viewName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("RENAME TABLE $oldObjectName$ TO $newObjectName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("oldObjectName", oldTableName, "newObjectName", newTableName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("RENAME VIEW $oldObjectName$ TO $newObjectName$");
        HashMap<String, String> valuesMap = DialectUtils.getValuesMap("oldObjectName", oldViewName, "newObjectName", newViewName);
        return new String[]{DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs)};
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return "SELECT LAST_NUMBER as last_value, MAX_VALUE, MIN_VALUE, CACHE_SIZE as cache_value, INCREMENT_BY, CYCLE_FLAG as is_cycled FROM DOMAIN.SEQUENCES";
    }

    @Override
    public boolean supportsAccessMethods() {
        return false;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return false;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return false;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return false;
    }

    @Override
    public boolean supportsRenameTable() {
        return true;
    }

    @Override
    public boolean supportsRenameView() {
        return true;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return true;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return null;
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return identifier;
    }

    private class MAXDBDialectHelper
    extends SAPDBDialect {
        public MAXDBDialectHelper() {
            this.registerColumnType(-5, "fixed(19,0)");
            this.registerColumnType(-2, 8000, "char($l) byte");
            this.registerColumnType(-2, "long varchar byte");
            this.registerColumnType(-7, "boolean");
            this.registerColumnType(2004, "long byte");
            this.registerColumnType(16, "boolean");
            this.registerColumnType(2005, "long varchar");
            this.registerColumnType(1, 8000, "char($l) ascii");
            this.registerColumnType(1, "long varchar ascii");
            this.registerColumnType(3, "decimal($p,$s)");
            this.registerColumnType(8, "double precision");
            this.registerColumnType(91, "date");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, 8000, "varchar($l) byte");
            this.registerColumnType(-4, "long byte");
            this.registerColumnType(-1, "long ascii");
            this.registerColumnType(2, "fixed($p,$s)");
            this.registerColumnType(7, "float($p)");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "fixed(3,0)");
            this.registerColumnType(-3, "long byte");
            this.registerColumnType(12, 8000, "varchar($l)");
            this.registerColumnType(12, "long ascii");
        }
    }
}

