/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.HibernateException;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.dialect.PostgreSQLDialect;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;

public class PostgreSQLDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private PostgreSQLDialectHelper _dialect = new PostgreSQLDialectHelper();
    private static final String[] ACCESS_METHODS = new String[]{"btree", "hash", "gist", "gin"};

    @Override
    public String getTypeName(int javaSqlTypesConst, int length, int precision, int scale, String typeNameOrNull) throws HibernateException {
        if (2 == javaSqlTypesConst && 0 < length) {
            return "numeric(" + length + (String)(0 < scale ? "," + scale : "") + ")";
        }
        return this._dialect.getTypeName(javaSqlTypesConst, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        boolean result = true;
        DatabaseObjectType type = info.getDatabaseObjectType();
        if (type.getName().equalsIgnoreCase("database")) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean supportsSchemasInTableDefinition() {
        return true;
    }

    @Override
    public String getLengthFunction(int dataType) {
        return "length";
    }

    @Override
    public String getMaxFunction() {
        return "max";
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 8 || dataType == 6) {
            return 53;
        }
        return 38;
    }

    @Override
    public int getMaxScale(int dataType) {
        return this.getMaxPrecision(dataType);
    }

    @Override
    public int getPrecisionDigits(int columnSize, int dataType) {
        if (columnSize == 2) {
            return 5;
        }
        if (columnSize == 4) {
            return 10;
        }
        return 19;
    }

    @Override
    public int getColumnLength(int columnSize, int dataType) {
        if (dataType == 12 && columnSize == -1) {
            return 2000;
        }
        return columnSize;
    }

    @Override
    public String getDisplayName() {
        return "PostgreSQL";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().toLowerCase().startsWith("postgresql");
    }

    @Override
    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnDropSQL(tableName, columnName, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getTableDropSQL(iTableInfo, true, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] colInfos, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{DialectUtils.getAddPrimaryKeySQL(ti, pkName, colInfos, false, qualifier, prefs, this)};
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        prefs.setQuoteColumnNames(false);
        return DialectUtils.getColumnCommentAlterSQL(info.getTableName(), info.getColumnName(), info.getRemarks(), qualifier, prefs, this);
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(info.getTableName());
        result.append(" ALTER COLUMN ");
        result.append(info.getColumnName());
        if (info.isNullable().equalsIgnoreCase("YES")) {
            result.append(" DROP NOT NULL");
        } else {
            result.append(" SET NOT NULL");
        }
        return new String[]{result.toString()};
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "RENAME COLUMN";
        String toClause = "TO";
        return DialectUtils.getColumnNameAlterSQL(from, to, alterClause, toClause, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(from.getTableName());
        result.append(" ALTER COLUMN ");
        result.append(to.getColumnName());
        result.append(" TYPE ");
        result.append(DialectUtils.getTypeName(to, this));
        list.add(result.toString());
        return list;
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("ALTER TABLE ");
        result.append(DialectUtils.shapeQualifiableIdentifier(info.getTableName(), qualifier, prefs, this));
        result.append(" ALTER COLUMN ");
        result.append(info.getColumnName());
        String defVal = info.getDefaultValue();
        if (defVal == null || "".equals(defVal)) {
            result.append(" DROP DEFAULT");
        } else {
            result.append(" SET DEFAULT ");
            if (JDBCTypeMapper.isNumberType(info.getDataType())) {
                result.append(defVal);
            } else {
                result.append("'");
                result.append(defVal);
                result.append("'");
            }
        }
        return result.toString();
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, true, false, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.POSTGRES;
    }

    private String shapeQualifiableIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.shapeQualifiableIdentifier(identifier, qualifier, prefs, this);
    }

    private String shapeIdentifier(String identifier, SqlGenerationPreferences prefs) {
        return DialectUtils.shapeIdentifier(identifier, prefs, this);
    }

    @Override
    public boolean supportsSequence() {
        return this._dialect.supportsSequences();
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsTablespace() {
        return true;
    }

    @Override
    public boolean supportsAccessMethods() {
        return true;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsRenameView() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return true;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsRenameTable() {
        return true;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return true;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return ACCESS_METHODS;
    }

    @Override
    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    public String getCreateTableSQL(String simpleName, List<TableColumnInfo> columns, List<TableColumnInfo> primaryKeys, SqlGenerationPreferences prefs, DatabaseObjectQualifier qualifier) {
        return DialectUtils.getCreateTableSQL(simpleName, columns, primaryKeys, prefs, qualifier, this);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE");
        sql.append(" ");
        sql.append(DialectUtils.shapeQualifiableIdentifier(oldTableName, qualifier, prefs, this));
        sql.append(" RENAME TO ");
        sql.append(DialectUtils.shapeIdentifier(newTableName, prefs, this));
        return sql.toString();
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getCreateViewSQL(viewName, definition, checkOption, qualifier, prefs, this);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{this.getRenameTableSQL(oldViewName, newViewName, qualifier, prefs)};
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropViewSQL(viewName, cascade, qualifier, prefs, this);
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String result = "";
        if (unique && accessMethod.equalsIgnoreCase("hash")) {
            String uniqueHashAccessMethodNotSupported = null;
            result = DialectUtils.getAddIndexSQL(this, indexName, tableName, uniqueHashAccessMethodNotSupported, columns, unique, tablespace, constraints, qualifier, prefs);
        } else {
            result = DialectUtils.getAddIndexSQL(this, indexName, tableName, accessMethod, columns, unique, tablespace, constraints, qualifier, prefs);
        }
        return result;
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropIndexSQL(indexName, cascade, qualifier, prefs, this);
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String cycleCause = cycle ? "CYCLE" : "NO CYCLE";
        return DialectUtils.getCreateSequenceSQL(sequenceName, increment, minimum, maximum, start, cache, cycleCause, qualifier, prefs, this);
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String cycleClause = cycle ? "CYCLE" : "NO CYCLE";
        String sql = DialectUtils.getAlterSequenceSQL(sequenceName, increment, minimum, maximum, restart, cache, cycleClause, qualifier, prefs, this);
        return new String[]{sql};
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT last_value, max_value, min_value, cache_value, increment_by, is_cycled FROM ");
        sql.append(this.shapeQualifiableIdentifier(sequenceName, qualifier, prefs));
        return sql.toString();
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropSequenceSQL(sequenceName, cascade, qualifier, prefs, this);
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getAddForeignKeyConstraintSQL(localTableName, refTableName, constraintName, deferrable, initiallyDeferred, matchFull, autoFKIndex, fkIndexName, localRefColumns, onUpdateAction, onDeleteAction, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{DialectUtils.getAddUniqueConstraintSQL(tableName, constraintName, columns, qualifier, prefs, (HibernateDialect)this)};
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        String sequenceName = column.getTableName() + "_" + column.getColumnName() + "_seq";
        String sequenceSQL = this.getCreateSequenceSQL(sequenceName, null, null, null, null, null, false, qualifier, prefs);
        result.add(sequenceSQL);
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE");
        sql.append(" ");
        sql.append(this.shapeQualifiableIdentifier(column.getTableName(), qualifier, prefs)).append("\n");
        sql.append(" ");
        sql.append("ALTER COLUMN");
        sql.append(" ");
        sql.append(this.shapeIdentifier(column.getColumnName(), prefs)).append("\n");
        sql.append(" ");
        sql.append("SET DEFAULT nextval('");
        sql.append(this.shapeQualifiableIdentifier(sequenceName, qualifier, prefs)).append("')");
        result.add(sql.toString());
        sql = new StringBuilder();
        sql.append("ALTER SEQUENCE ");
        sql.append(" ");
        sql.append(this.shapeQualifiableIdentifier(sequenceName, qualifier, prefs)).append("\n");
        sql.append(" OWNED BY ");
        sql.append(this.shapeQualifiableIdentifier(column.getTableName(), qualifier, prefs));
        sql.append(".");
        sql.append(this.shapeIdentifier(column.getColumnName(), prefs));
        result.add(sql.toString());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropConstraintSQL(tableName, constraintName, qualifier, prefs, this);
    }

    @Override
    public String getInsertIntoSQL(String tableName, List<String> columns, String query, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getInsertIntoSQL(tableName, columns, query, qualifier, prefs, this);
    }

    @Override
    public String[] getUpdateSQL(String tableName, String[] setColumns, String[] setValues, String[] fromTables, String[] whereColumns, String[] whereValues, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int i;
        if (setColumns == null && setValues == null || setColumns != null && setValues != null && setColumns.length == 0 && setValues.length == 0) {
            return new String[0];
        }
        if (setColumns != null && setValues != null && setColumns.length != setValues.length || setColumns == null || setValues == null) {
            throw new IllegalArgumentException("The amount of SET columns and values must be the same!");
        }
        if (whereColumns != null && whereValues != null && whereColumns.length != whereValues.length || whereColumns == null && whereValues != null || whereColumns != null && whereValues == null) {
            throw new IllegalArgumentException("The amount of WHERE columns and values must be the same!");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(this.shapeQualifiableIdentifier(tableName, qualifier, prefs));
        sql.append(" SET ");
        for (i = 0; i < setColumns.length; ++i) {
            sql.append(this.shapeIdentifier(setColumns[i], prefs));
            if (setValues[i] == null) {
                sql.append(" = NULL");
            } else {
                sql.append(" = ").append(setValues[i]);
            }
            sql.append(", ");
        }
        sql.setLength(sql.length() - 2);
        if (fromTables != null) {
            sql.append("\n FROM ");
            for (String from : fromTables) {
                sql.append(this.shapeQualifiableIdentifier(from, qualifier, prefs)).append(", ");
            }
            sql.setLength(sql.length() - 2);
        }
        if (whereColumns != null && whereColumns.length != 0) {
            sql.append("\n WHERE ");
            for (i = 0; i < whereColumns.length; ++i) {
                sql.append(this.shapeIdentifier(whereColumns[i], prefs));
                if (whereValues[i] == null) {
                    sql.append(" IS NULL");
                } else {
                    sql.append(" = ").append(whereValues[i]);
                }
                sql.append(" AND ");
            }
            sql.setLength(sql.length() - 5);
        }
        return new String[]{sql.toString()};
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = true;
        boolean addNullClause = true;
        result.add(DialectUtils.getAddColumSQL(column, this, addDefaultClause, supportsNullQualifier, addNullClause, qualifier, prefs));
        if (column.getRemarks() != null && !"".equals(column.getRemarks())) {
            result.add(this.getColumnCommentAlterSQL(column, qualifier, prefs));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        result.append("select view_definition from information_schema.views where table_schema = '");
        result.append(qualifier.getSchema());
        result.append("' and table_name =  '");
        result.append(viewName);
        result.append("'");
        return result.toString();
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuilder result = new StringBuilder();
        if (prefs.isQualifyTableNames()) {
            if (prefs.isQuoteIdentifiers()) {
                result.append(this.openQuote());
            }
            result.append(qualifier.getSchema());
            if (prefs.isQuoteIdentifiers()) {
                result.append(this.closeQuote());
            }
            result.append(".");
        }
        if (prefs.isQuoteIdentifiers()) {
            result.append(this.openQuote());
        }
        result.append(identifier);
        if (prefs.isQuoteIdentifiers()) {
            result.append(this.closeQuote());
        }
        return result.toString();
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return false;
    }

    @Override
    public int getJavaTypeForNativeType(String nativeColumnTypeName) {
        if ("character_data".equalsIgnoreCase(nativeColumnTypeName)) {
            return 1;
        }
        if ("cardinal_number".equalsIgnoreCase(nativeColumnTypeName)) {
            return 4;
        }
        if ("xml".equalsIgnoreCase(nativeColumnTypeName)) {
            return 12;
        }
        return super.getJavaTypeForNativeType(nativeColumnTypeName);
    }

    private class PostgreSQLDialectHelper
    extends PostgreSQLDialect {
        public PostgreSQLDialectHelper() {
            this.registerColumnType(-5, "bigint");
            this.registerColumnType(-2, "bytea");
            this.registerColumnType(-7, "bool");
            this.registerColumnType(2004, "bytea");
            this.registerColumnType(16, "bool");
            this.registerColumnType(1, 8000, "char($l)");
            this.registerColumnType(1, "text");
            this.registerColumnType(2005, "text");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p,2)");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, "bytea");
            this.registerColumnType(-1, "text");
            this.registerColumnType(2, "numeric($p)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "timestamp");
            this.registerColumnType(-6, "int");
            this.registerColumnType(-3, "bytea");
            this.registerColumnType(12, 8000, "varchar($l)");
            this.registerColumnType(12, "text");
        }
    }
}

