/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.CommonHibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.dialects.DialectUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.HibernateException;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.dialect.SybaseDialect;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.antlr.stringtemplate.StringTemplate;

public class SybaseDialectExt
extends CommonHibernateDialect
implements HibernateDialect {
    private SybaseDialectHelper _dialect = new SybaseDialectHelper();

    @Override
    public String getTypeName(int javaSqlTypesConst, int length, int precision, int scale, String typeNameOrNull) throws HibernateException {
        return this._dialect.getTypeName(javaSqlTypesConst, length, precision, scale);
    }

    @Override
    public boolean canPasteTo(IDatabaseObjectInfo info) {
        boolean result = true;
        DatabaseObjectType type = info.getDatabaseObjectType();
        if (type.getName().equalsIgnoreCase("database") || type.getName().equalsIgnoreCase("catalog")) {
            result = false;
        }
        return result;
    }

    @Override
    public String getLengthFunction(int dataType) {
        return "datalength";
    }

    @Override
    public int getMaxPrecision(int dataType) {
        if (dataType == 8 || dataType == 6) {
            return 48;
        }
        return 38;
    }

    @Override
    public String getDisplayName() {
        return "Sybase";
    }

    @Override
    public boolean supportsProduct(String databaseProductName, String databaseProductVersion) {
        if (databaseProductName == null) {
            return false;
        }
        String lname = databaseProductName.trim().toLowerCase();
        return lname.startsWith("sybase") || lname.startsWith("adaptive") || lname.startsWith("sql server") || lname.startsWith("ase");
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    public String getColumnDropSQL(String tableName, String columnName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getColumnDropSQL(tableName, columnName, qualifier, prefs, this);
    }

    @Override
    public List<String> getTableDropSQL(ITableInfo iTableInfo, boolean cascadeConstraints, boolean isMaterializedView, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        List<String> dropTableSQL = DialectUtils.getTableDropSQL(iTableInfo, false, cascadeConstraints, false, "CASCADE", false, qualifier, prefs, this);
        if (cascadeConstraints) {
            ArrayList<String> result = new ArrayList<String>();
            ForeignKeyInfo[] fks = iTableInfo.getExportedKeys();
            if (fks != null && fks.length > 0) {
                for (int i = 0; i < fks.length; ++i) {
                    ForeignKeyInfo info = fks[i];
                    String fkName = info.getForeignKeyName();
                    String fkTable = info.getForeignKeyTableName();
                    StringBuilder tmp = new StringBuilder();
                    tmp.append("ALTER TABLE ");
                    tmp.append(fkTable);
                    tmp.append(" DROP CONSTRAINT ");
                    tmp.append(fkName);
                    result.add(tmp.toString());
                }
            }
            result.addAll(dropTableSQL);
            return result;
        }
        return dropTableSQL;
    }

    @Override
    public String[] getAddPrimaryKeySQL(String pkName, TableColumnInfo[] columns, ITableInfo ti, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return new String[]{DialectUtils.getAddPrimaryKeySQL(ti, pkName, columns, false, qualifier, prefs, this)};
    }

    @Override
    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    public String getColumnCommentAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        int featureId = 0;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public boolean supportsAlterColumnNull() {
        return true;
    }

    @Override
    public String[] getColumnNullableAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String alterClause = "MODIFY";
        return new String[]{DialectUtils.getColumnNullableAlterSQL(info, this, alterClause, false, qualifier, prefs)};
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    public String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringBuffer result = new StringBuffer();
        result.append("exec sp_rename ");
        result.append("'");
        result.append(from.getTableName());
        result.append(".");
        result.append(from.getColumnName());
        result.append("'");
        result.append(", ");
        result.append(to.getColumnName());
        return result.toString();
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public List<String> getColumnTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) throws UnsupportedOperationException {
        String alterClause = "MODIFY";
        String setClause = "";
        return DialectUtils.getColumnTypeAlterSQL(this, alterClause, setClause, false, from, to, qualifier, prefs);
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    public String getColumnDefaultAlterSQL(TableColumnInfo info, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 1;
        String msg = DialectUtils.getUnsupportedMessage(this, featureId);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropPrimaryKeySQL(String pkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropPrimaryKeySQL(pkName, tableName, true, false, qualifier, prefs, this);
    }

    @Override
    public String getDropForeignKeySQL(String fkName, String tableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropForeignKeySQL(fkName, tableName, qualifier, prefs, this);
    }

    @Override
    public List<String> getCreateTableSQL(List<ITableInfo> tables, ISQLDatabaseMetaData md, CreateScriptPreferences prefs, boolean isJdbcOdbc) throws SQLException {
        return DialectUtils.getCreateTableSQL(tables, md, this, prefs, isJdbcOdbc);
    }

    @Override
    public DialectType getDialectType() {
        return DialectType.SYBASEASE;
    }

    @Override
    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"UNIQUE", "NON-UNIQUE"};
    }

    @Override
    public String[] getIndexStorageOptions() {
        return new String[]{"NONCLUSTERED", "CLUSTERED"};
    }

    @Override
    public String[] getAddAutoIncrementSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 21;
        String msg = DialectUtils.getUnsupportedMessage(this, 21);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getAddColumnSQL(TableColumnInfo column, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean addDefaultClause = true;
        boolean supportsNullQualifier = true;
        boolean addNullClause = true;
        String sql = DialectUtils.getAddColumSQL(column, this, addDefaultClause, supportsNullQualifier, addNullClause, qualifier, prefs);
        result.add(sql);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getAddForeignKeyConstraintSQL(String localTableName, String refTableName, String constraintName, Boolean deferrable, Boolean initiallyDeferred, Boolean matchFull, boolean autoFKIndex, String fkIndexName, Collection<String[]> localRefColumns, String onUpdateAction, String onDeleteAction, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $childTableName$ ADD $constraint$ $constraintName$ FOREIGN KEY ( $childColumn; separator=\",\"$ ) REFERENCES $parentTableName$ ( $parentColumn; separator=\",\"$ )");
        HashMap<String, String> fkValuesMap = new HashMap<String, String>();
        fkValuesMap.put("childTableName", localTableName);
        fkValuesMap.put("constraint", "CONSTRAINT");
        fkValuesMap.put("constraintName", constraintName);
        fkValuesMap.put("parentTableName", refTableName);
        StringTemplate childIndexST = null;
        HashMap<String, String> ckIndexValuesMap = null;
        return DialectUtils.getAddForeignKeyConstraintSQL(st, fkValuesMap, childIndexST, ckIndexValuesMap, localRefColumns, qualifier, prefs, this);
    }

    @Override
    public String[] getAddUniqueConstraintSQL(String tableName, String constraintName, TableColumnInfo[] columns, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("ALTER TABLE $tableName$ ADD CONSTRAINT $constraintName$ UNIQUE ($columnName;  separator=\",\"$)");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("tableName", tableName);
        valuesMap.put("constraintName", constraintName);
        return new String[]{DialectUtils.getAddUniqueConstraintSQL(st, valuesMap, columns, qualifier, prefs, (HibernateDialect)this)};
    }

    @Override
    public String[] getAlterSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String restart, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 16;
        String msg = DialectUtils.getUnsupportedMessage(this, 16);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getCreateIndexSQL(String indexName, String tableName, String accessMethod, String[] columns, boolean unique, String tablespace, String constraints, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE $unique$ $storageOption$ INDEX $indexName$ ON $tableName$ ( $columnName; separator=\",\"$ )");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        if (unique) {
            valuesMap.put("unique", "UNIQUE");
        }
        valuesMap.put("indexName", indexName);
        valuesMap.put("tableName", tableName);
        return DialectUtils.getAddIndexSQL(this, st, valuesMap, columns, qualifier, prefs);
    }

    @Override
    public String getCreateSequenceSQL(String sequenceName, String increment, String minimum, String maximum, String start, String cache, boolean cycle, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 15;
        String msg = DialectUtils.getUnsupportedMessage(this, 15);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getCreateTableSQL(String tableName, List<TableColumnInfo> columns, List<TableColumnInfo> primaryKeys, SqlGenerationPreferences prefs, DatabaseObjectQualifier qualifier) {
        return DialectUtils.getCreateTableSQL(tableName, columns, primaryKeys, prefs, qualifier, this);
    }

    @Override
    public String getCreateViewSQL(String viewName, String definition, String checkOption, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("CREATE VIEW $viewName$ AS $selectStatement$ $with$ $checkOptionType$ $checkOption$");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("viewName", viewName);
        valuesMap.put("selectStatement", definition);
        if (checkOption != null && !"".equals(checkOption)) {
            valuesMap.put("with", "WITH");
            valuesMap.put("checkOption", "CHECK OPTION");
        }
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String getDropConstraintSQL(String tableName, String constraintName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getDropConstraintSQL(tableName, constraintName, qualifier, prefs, this);
    }

    @Override
    public String getDropIndexSQL(String tableName, String indexName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("DROP INDEX $tableName$.$indexName$");
        st.setAttribute("indexName", (Object)indexName);
        st.setAttribute("tableName", (Object)tableName);
        return st.toString();
    }

    @Override
    public String getDropSequenceSQL(String sequenceName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 18;
        String msg = DialectUtils.getUnsupportedMessage(this, 18);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String getDropViewSQL(String viewName, boolean cascade, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        Boolean cascadeNotSupported = null;
        return DialectUtils.getDropViewSQL(viewName, cascadeNotSupported, qualifier, prefs, this);
    }

    @Override
    public String getInsertIntoSQL(String tableName, List<String> columns, String valuesPart, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return DialectUtils.getInsertIntoSQL(tableName, columns, valuesPart, qualifier, prefs, this);
    }

    @Override
    public String getRenameTableSQL(String oldTableName, String newTableName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("sp_rename $oldObjectName$, $newObjectName$");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("oldObjectName", oldTableName);
        valuesMap.put("newObjectName", newTableName);
        return DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs);
    }

    @Override
    public String[] getRenameViewSQL(String oldViewName, String newViewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        StringTemplate st = new StringTemplate("sp_rename $oldObjectName$, $newObjectName$");
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("oldObjectName", oldViewName);
        valuesMap.put("newObjectName", newViewName);
        return new String[]{DialectUtils.bindTemplateAttributes(this, st, valuesMap, qualifier, prefs)};
    }

    @Override
    public String getSequenceInformationSQL(String sequenceName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        int featureId = 17;
        String msg = DialectUtils.getUnsupportedMessage(this, 17);
        throw new UnsupportedOperationException(msg);
    }

    @Override
    public String[] getUpdateSQL(String tableName, String[] setColumns, String[] setValues, String[] fromTables, String[] whereColumns, String[] whereValues, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String templateStr = "";
        templateStr = fromTables != null ? "UPDATE $destTableName$ SET $columnName$ = (SELECT $columnName$ FROM $sourceTableName$ where $sourceTableName$.$whereColumnName$ = $destTableName$.$whereValue$)" : "UPDATE $destTableName$ SET $columnName$ = $columnValue$ where $whereColumnName$ = $whereValue$";
        StringTemplate st = new StringTemplate(templateStr);
        return DialectUtils.getUpdateSQL(st, tableName, setColumns, setValues, fromTables, whereColumns, whereValues, qualifier, prefs, this);
    }

    @Override
    public boolean supportsAccessMethods() {
        return true;
    }

    @Override
    public boolean supportsAddForeignKeyConstraint() {
        return true;
    }

    @Override
    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    @Override
    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public boolean supportsCheckOptionsForViews() {
        return true;
    }

    @Override
    public boolean supportsCreateIndex() {
        return true;
    }

    @Override
    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    @Override
    public boolean supportsCreateView() {
        return true;
    }

    @Override
    public boolean supportsDropConstraint() {
        return true;
    }

    @Override
    public boolean supportsDropIndex() {
        return true;
    }

    @Override
    public boolean supportsDropSequence() {
        return false;
    }

    @Override
    public boolean supportsDropView() {
        return true;
    }

    @Override
    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsMultipleRowInserts() {
        return true;
    }

    @Override
    public boolean supportsRenameTable() {
        return true;
    }

    @Override
    public boolean supportsRenameView() {
        return true;
    }

    @Override
    public boolean supportsSequence() {
        return false;
    }

    @Override
    public boolean supportsSequenceInformation() {
        return false;
    }

    @Override
    public boolean supportsTablespace() {
        return false;
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public boolean supportsAddColumn() {
        return true;
    }

    @Override
    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    public String getViewDefinitionSQL(String viewName, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String sql = "select text from sysobjects inner join syscomments on syscomments.id = sysobjects.id where (loginame = '$catalogName$' or loginame is null) and name = '$viewName$' and text not like '%--%'";
        StringTemplate st = new StringTemplate(sql);
        st.setAttribute("catalogName", (Object)qualifier.getCatalog());
        st.setAttribute("viewName", (Object)viewName);
        return st.toString();
    }

    @Override
    public String getQualifiedIdentifier(String identifier, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        return identifier;
    }

    @Override
    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    public String getBinaryLiteralString(byte[] binaryData) {
        return "0x" + DialectUtils.toHexString(binaryData);
    }

    @Override
    public String getNullColumnString() {
        return " NULL";
    }

    private class SybaseDialectHelper
    extends SybaseDialect {
        public SybaseDialectHelper() {
            this.registerColumnType(-5, "numeric($p)");
            this.registerColumnType(-2, "image");
            this.registerColumnType(-7, "tinyint");
            this.registerColumnType(2004, "image");
            this.registerColumnType(16, "tinyint");
            this.registerColumnType(1, 255, "char($l)");
            this.registerColumnType(1, "text");
            this.registerColumnType(2005, "text");
            this.registerColumnType(91, "date");
            this.registerColumnType(3, "decimal($p,$s)");
            this.registerColumnType(8, "float($p)");
            this.registerColumnType(6, "float($p)");
            this.registerColumnType(4, "int");
            this.registerColumnType(-4, "image");
            this.registerColumnType(-1, "text");
            this.registerColumnType(2, "numeric($p,$s)");
            this.registerColumnType(7, "real");
            this.registerColumnType(5, "smallint");
            this.registerColumnType(92, "time");
            this.registerColumnType(93, "datetime");
            this.registerColumnType(-6, "tinyint");
            this.registerColumnType(-3, "image");
            this.registerColumnType(12, 255, "varchar($l)");
            this.registerColumnType(12, "text");
        }
    }
}

