/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.dialect;

import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.HibernateException;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.dialect.TypeNames;

public abstract class Dialect {
    private final TypeNames typeNames = new TypeNames();

    protected Dialect() {
    }

    public String getTypeName(int code) throws HibernateException {
        String result = this.typeNames.get(code);
        if (result == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + code);
        }
        return result;
    }

    public String getTypeName(int code, int length, int precision, int scale) throws HibernateException {
        String result = this.typeNames.get(code, length, precision, scale);
        if (result == null) {
            throw new HibernateException("No type mapping for java.sql.Types code: " + code + ", length: " + length);
        }
        return result;
    }

    protected void registerColumnType(int code, int capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void registerColumnType(int code, String name) {
        this.typeNames.put(code, name);
    }

    public boolean supportsSequences() {
        return false;
    }
}

