/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.fw.util.BaseException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class BeanPropertyTableModel
extends DefaultTableModel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BeanPropertyTableModel.class);
    private Object _bean;
    private String _nameColumnName = s_stringMgr.getString("BeanPropertyTableModel.namecolumn");
    private String _valueColumnName = s_stringMgr.getString("BeanPropertyTableModel.valuecolumn");

    public void setBean(Object bean) throws BaseException {
        this._bean = bean;
        this.refresh();
    }

    public void refresh() throws BaseException {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(this._nameColumnName);
        columnNames.add(this._valueColumnName);
        Vector<Vector> columnData = new Vector<Vector>();
        if (this._bean != null) {
            try {
                BeanInfo info = Introspector.getBeanInfo(this._bean.getClass(), 1);
                this.processBeanInfo(info, columnData);
            }
            catch (Exception ex) {
                throw new BaseException(ex);
            }
        }
        Collections.sort(columnData, new DataSorter());
        this.setDataVector(columnData, columnNames);
    }

    private void processBeanInfo(BeanInfo info, Vector<Vector> columnData) throws InvocationTargetException, IllegalAccessException {
        BeanInfo[] extra = info.getAdditionalBeanInfo();
        if (extra != null) {
            for (int i = 0; i < extra.length; ++i) {
                this.processBeanInfo(extra[i], columnData);
            }
        }
        PropertyDescriptor[] propDesc = info.getPropertyDescriptors();
        for (int i = 0; i < propDesc.length; ++i) {
            Vector<Object> line;
            String propName = propDesc[i].getName();
            Method getter = propDesc[i].getReadMethod();
            if (propName == null || getter == null || (line = this.generateLine(propName, this._bean, getter)) == null) continue;
            columnData.add(line);
        }
    }

    protected Vector<Object> generateLine(String propName, Object bean, Method getter) throws InvocationTargetException, IllegalAccessException {
        Vector<Object> line = new Vector<Object>();
        line.add(propName);
        line.add(this.executeGetter(bean, getter));
        return line;
    }

    protected Object executeGetter(Object bean, Method getter) throws InvocationTargetException, IllegalAccessException {
        return getter.invoke(bean, (Object[])null);
    }

    public void setNameColumnName(String value) {
        this._nameColumnName = value;
    }

    public void setValueColumnName(String value) {
        this._valueColumnName = value;
    }

    private static final class DataSorter
    implements Comparator<Object> {
        private DataSorter() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Vector v1 = (Vector)o1;
            Vector v2 = (Vector)o2;
            String lhs = (String)v1.get(0);
            String rhs = (String)v2.get(0);
            return lhs.compareToIgnoreCase(rhs);
        }
    }
}

