/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ComponentIndicator {
    public static final int DEFAULT_MAX_INDICATE_COUNT = 10;
    private Timer _timer;
    private int _indicateCount;
    private int _maxIndicateCount;

    public void init(Component componentToIndicate) {
        this.init(componentToIndicate, 10);
    }

    public void init(Component componentToIndicate, int maxIndicateCount) {
        this._maxIndicateCount = maxIndicateCount;
        this._timer = new Timer(500, e -> this.onIndicateComponent(componentToIndicate));
        this._timer.setRepeats(true);
        this._timer.start();
        SwingUtilities.invokeLater(() -> this.onIndicateComponent(componentToIndicate));
    }

    private void onIndicateComponent(Component component) {
        Graphics graphics = component.getGraphics();
        if (null == graphics) {
            return;
        }
        if (this._indicateCount++ % 2 == 0) {
            Color formerColor = graphics.getColor();
            graphics.setColor(Color.red);
            Stroke formerStroke = null;
            int strokeWidth = 4;
            if (graphics instanceof Graphics2D) {
                formerStroke = ((Graphics2D)graphics).getStroke();
                ((Graphics2D)graphics).setStroke(new BasicStroke(strokeWidth));
            }
            graphics.drawRect(strokeWidth, strokeWidth, component.getBounds().width - 2 * strokeWidth, component.getBounds().height - 2 * strokeWidth);
            graphics.setColor(formerColor);
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setStroke(formerStroke);
            }
        } else {
            component.repaint();
        }
        if (this._indicateCount > this._maxIndicateCount) {
            this._timer.stop();
            component.repaint();
        }
    }
}

