/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.fw.gui.DontShowAgainResult;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallToolTipInfoButton;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DontShowAgainDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DontShowAgainDialog.class);
    private JCheckBox chkDontShowAgain = new JCheckBox(s_stringMgr.getString("DontShowAgainDialog.dontShowAgainMsg"));
    private JButton btnYes;
    private JButton btnNo;
    private JButton btnCancel = new JButton(s_stringMgr.getString("DontShowAgainDialog.cancel"));
    private DontShowAgainResult _result = new DontShowAgainResult();

    public DontShowAgainDialog(Window owner, String msg, String switchBackOnHowTo) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.createUI(msg, switchBackOnHowTo);
        this.btnYes.addActionListener(e -> this.onYes());
        this.btnNo.addActionListener(e -> this.onNo());
        this.btnCancel.addActionListener(e -> this.onCancel());
        this.getRootPane().setDefaultButton(this.btnYes);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent event) {
                DontShowAgainDialog.this.setSize(new Dimension(DontShowAgainDialog.this.getWidth(), DontShowAgainDialog.this.getPreferredSize().height));
            }
        });
    }

    private void onCancel() {
        this._result.setCancel(true);
        this.close();
    }

    private void onNo() {
        this._result.setNo(true);
        this.close();
    }

    private void onYes() {
        this._result.setYes(true);
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public DontShowAgainResult showAndGetResult(String identifier, int defaultWidth, int defaultHeight) {
        GUIUtils.enableCloseByEscape(this);
        GUIUtils.initLocation(this, defaultWidth, defaultHeight, "DontShowAgainDialog." + identifier);
        this.setVisible(true);
        this._result.setDontShowAgain(this.chkDontShowAgain.isSelected());
        return this._result;
    }

    private void createUI(String msg, String switchBackOnHowTo) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 20), 0, 0);
        this.add((Component)new JLabel(UIManager.getIcon("OptionPane.questionIcon")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 10), 0, 0);
        this.add((Component)new MultipleLineLabel(msg), gbc);
        gbc = new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(5, 10, 0, 10), 0, 0);
        this.add((Component)this.createDontShowAgainPanel(switchBackOnHowTo), gbc);
        gbc = new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 11, 0, new Insets(10, 10, 10, 10), 0, 0);
        this.add((Component)this.createButtonsPanel(), gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)new JPanel(), gbc);
    }

    private JPanel createDontShowAgainPanel(String switchBackOnHowTo) {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)this.chkDontShowAgain, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new SmallToolTipInfoButton(switchBackOnHowTo).getButton(), gbc);
        return ret;
    }

    private JPanel createButtonsPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.btnYes = new JButton(s_stringMgr.getString("DontShowAgainDialog.yes"));
        this.btnYes.setMnemonic(s_stringMgr.getString("DontShowAgainDialog.yes.mnemonic").charAt(0));
        ret.add((Component)this.btnYes, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        this.btnNo = new JButton(s_stringMgr.getString("DontShowAgainDialog.no"));
        this.btnNo.setMnemonic(s_stringMgr.getString("DontShowAgainDialog.no.mnemonic").charAt(0));
        ret.add((Component)this.btnNo, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        ret.add((Component)this.btnCancel, gbc);
        return ret;
    }
}

