/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class EditableComboBoxHandler {
    private final JComboBox _cbo;
    private final String _prefKeyPrefix;
    private final int _maxItemCount;
    private String _defaultString;

    public EditableComboBoxHandler(JComboBox cbo, String prefKeyPrefix) {
        this(cbo, prefKeyPrefix, 10, null);
    }

    public EditableComboBoxHandler(JComboBox cbo, String prefKeyPrefix, int maxItemCount) {
        this(cbo, prefKeyPrefix, maxItemCount, null);
    }

    public EditableComboBoxHandler(JComboBox cbo, String prefKeyPrefix, int maxItemCount, String defaultString) {
        this._cbo = cbo;
        this._cbo.setEditable(true);
        this._prefKeyPrefix = prefKeyPrefix;
        this._maxItemCount = maxItemCount;
        this._defaultString = defaultString;
        this.loadComboBox();
    }

    private void loadComboBox() {
        String item;
        int i = 0;
        while (null != (item = Props.getString(this._prefKeyPrefix + i, null))) {
            this._cbo.addItem(item);
            ++i;
        }
        if (!StringUtilities.isEmpty(this._defaultString, true)) {
            this._cbo.getEditor().setItem(this._defaultString);
            this._cbo.getEditor().selectAll();
        } else {
            this._cbo.getEditor().setItem(null);
        }
    }

    public void selectFirstItemIfExists() {
        if (0 < this._cbo.getItemCount()) {
            this.addOrReplaceCurrentItem((String)this._cbo.getItemAt(0));
        }
    }

    public void addOrReplaceCurrentItem(String newItem) {
        for (int i = 0; i < this._cbo.getItemCount(); ++i) {
            if (!newItem.equals(this._cbo.getItemAt(i))) continue;
            this._cbo.removeItemAt(i);
        }
        ((DefaultComboBoxModel)this._cbo.getModel()).insertElementAt(newItem, 0);
        ArrayList<String> itemsToRemove = new ArrayList<String>();
        for (int i = 0; i < this._cbo.getItemCount(); ++i) {
            String item = (String)this._cbo.getItemAt(i);
            if (this._maxItemCount > i && !StringUtilities.isEmpty(item)) {
                Props.putString(this._prefKeyPrefix + i, item);
                continue;
            }
            itemsToRemove.add(item);
        }
        for (String item : itemsToRemove) {
            this._cbo.removeItem(item);
        }
        if (0 < this._cbo.getItemCount()) {
            this._cbo.setSelectedIndex(0);
        }
    }

    public void focus() {
        GUIUtils.forceFocus(this._cbo.getEditor().getEditorComponent());
    }

    public String getItem() {
        return "" + this._cbo.getEditor().getItem();
    }

    public void addDocumentListener(DocumentListener documentListener) {
        if (!(this._cbo.getEditor().getEditorComponent() instanceof JTextComponent)) {
            throw new UnsupportedOperationException("Failed to add DocumentListener to editable Combobox as the ComboBoxes editor isn't an instance of JTextComponent");
        }
        ((JTextComponent)this._cbo.getEditor().getEditorComponent()).getDocument().addDocumentListener(documentListener);
    }

    public void saveCurrentItem() {
        this.addOrReplaceCurrentItem(this.getItem());
    }
}

