/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ErrorDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ErrorDialog.class);
    private JButton _closeBtn;
    private JButton _stackTraceBtn;
    private JButton _moreBtn;
    private JScrollPane _stackTraceScroller;
    private JScrollPane _moreErrorsScroller;
    private ActionListener _stackTraceHandler = new StackTraceButtonHandler();
    private ActionListener _closeHandler = new CloseButtonHandler();
    private ActionListener _moreHandler = new MoreButtonHandler();

    public ErrorDialog(Throwable th) {
        this((Frame)null, th);
    }

    public ErrorDialog(Frame owner, Throwable th) {
        super(owner, s_stringMgr.getString("ErrorDialog.error"), true);
        this.createUserInterface(null, th);
    }

    public ErrorDialog(Dialog owner, Throwable th) {
        super(owner, s_stringMgr.getString("ErrorDialog.error"), true);
        this.createUserInterface(null, th);
    }

    public ErrorDialog(Frame owner, String msg) {
        super(owner, s_stringMgr.getString("ErrorDialog.error"), true);
        this.createUserInterface(msg, null);
    }

    public ErrorDialog(Frame owner, String msg, Throwable th) {
        super(owner, s_stringMgr.getString("ErrorDialog.error"), true);
        this.createUserInterface(msg, th);
    }

    public ErrorDialog(Dialog owner, String msg) {
        super(owner, s_stringMgr.getString("ErrorDialog.error"), true);
        this.createUserInterface(msg, null);
    }

    @Override
    public void dispose() {
        if (this._closeBtn != null && this._closeHandler != null) {
            this._closeBtn.removeActionListener(this._closeHandler);
        }
        if (this._stackTraceBtn != null && this._stackTraceHandler != null) {
            this._stackTraceBtn.removeActionListener(this._stackTraceHandler);
        }
        if (this._moreBtn != null && this._moreHandler != null) {
            this._moreBtn.removeActionListener(this._moreHandler);
        }
        super.dispose();
    }

    private void createUserInterface(String msg, Throwable th) {
        if (msg == null || msg.length() == 0) {
            msg = Utilities.getExceptionStringSave(th);
        }
        if (msg == null || msg.length() == 0) {
            msg = s_stringMgr.getString("ErrorDialog.unknownerror");
        }
        this._stackTraceScroller = new JScrollPane(new StackTracePanel(th));
        this._stackTraceScroller.setVisible(false);
        MoreErrorsPanel moreErrPnl = this.createMoreErrorsPanel(th);
        if (moreErrPnl != null) {
            this._moreErrorsScroller = new JScrollPane(moreErrPnl);
            this._moreErrorsScroller.setVisible(false);
        }
        Container content = this.getContentPane();
        content.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        content.add((Component)this.createMessagePanel(msg, th), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0);
        content.add((Component)this.createButtonsPanel(th), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 3.0, 3.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0);
        content.add((Component)this._stackTraceScroller, gbc);
        if (this._moreErrorsScroller != null) {
            gbc = new GridBagConstraints(0, 2, 1, 1, 3.0, 3.0, 18, 1, new Insets(0, 5, 5, 5), 0, 0);
            content.add((Component)this._moreErrorsScroller, gbc);
        }
        this.getRootPane().setDefaultButton(this._closeBtn);
        if (null == th) {
            this.setSize(400, 200);
        } else {
            this.setSize(400, 500);
        }
        GUIUtils.enableCloseByEscape(this);
        GUIUtils.centerWithinParent(this);
    }

    private JComponent createMessagePanel(String msg, Throwable th) {
        if ((msg == null || msg.length() == 0) && th != null) {
            msg = Utilities.getExceptionStringSave(th);
        }
        if (msg == null || msg.length() == 0) {
            msg = s_stringMgr.getString("ErrorDialog.unknownerror");
        }
        JScrollPane sp = new JScrollPane(new MessagePanel(msg));
        return sp;
    }

    private JPanel createButtonsPanel(Throwable th) {
        JPanel btnsPnl = new JPanel();
        if (th != null) {
            this._stackTraceBtn = new JButton(s_stringMgr.getString("ErrorDialog.stacktrace"));
            this._stackTraceBtn.addActionListener(this._stackTraceHandler);
            btnsPnl.add(this._stackTraceBtn);
            if (this._moreErrorsScroller != null) {
                this._moreBtn = new JButton(s_stringMgr.getString("ErrorDialog.more"));
                this._moreBtn.addActionListener(this._moreHandler);
                btnsPnl.add(this._moreBtn);
            }
        }
        this._closeBtn = new JButton(s_stringMgr.getString("ErrorDialog.close"));
        this._closeBtn.addActionListener(this._closeHandler);
        btnsPnl.add(this._closeBtn);
        return btnsPnl;
    }

    private static Color getTextAreaBackgroundColor() {
        return (Color)UIManager.get("TextArea.background");
    }

    private MoreErrorsPanel createMoreErrorsPanel(Throwable th) {
        SQLException ex;
        if (th instanceof SQLException && (ex = ((SQLException)th).getNextException()) != null) {
            return new MoreErrorsPanel(ex);
        }
        return null;
    }

    private final class MoreButtonHandler
    implements ActionListener {
        private MoreButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            boolean currentlyVisible = ErrorDialog.this._moreErrorsScroller.isVisible();
            if (!currentlyVisible) {
                ErrorDialog.this._stackTraceScroller.setVisible(false);
            }
            ErrorDialog.this._moreErrorsScroller.setVisible(!currentlyVisible);
            ErrorDialog.this.validate();
        }
    }

    private final class StackTraceButtonHandler
    implements ActionListener {
        private StackTraceButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            boolean currentlyVisible = ErrorDialog.this._stackTraceScroller.isVisible();
            if (!currentlyVisible && ErrorDialog.this._moreErrorsScroller != null) {
                ErrorDialog.this._moreErrorsScroller.setVisible(false);
            }
            ErrorDialog.this._stackTraceScroller.setVisible(!currentlyVisible);
            ErrorDialog.this.validate();
        }
    }

    private final class CloseButtonHandler
    implements ActionListener {
        private CloseButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ErrorDialog.this.dispose();
        }
    }

    private final class MoreErrorsPanel
    extends MultipleLineLabel {
        MoreErrorsPanel(SQLException ex) {
            StringBuffer buf = new StringBuffer();
            this.setBackground(ErrorDialog.getTextAreaBackgroundColor());
            while (ex != null) {
                String msg = ex.getMessage();
                if (msg != null && msg.length() > 0) {
                    buf.append(msg).append('\n');
                } else {
                    buf.append(ex.toString()).append('\n');
                }
                ex = ex.getNextException();
            }
            this.setText(buf.toString());
        }
    }

    private final class StackTracePanel
    extends MultipleLineLabel {
        StackTracePanel(Throwable th) {
            this.setBackground(ErrorDialog.getTextAreaBackgroundColor());
            if (th != null) {
                this.setText(Utilities.getStackTrace(th));
            }
        }
    }

    private final class MessagePanel
    extends MultipleLineLabel {
        MessagePanel(String msg) {
            this.setText(msg);
            this.setBackground(ErrorDialog.getTextAreaBackgroundColor());
        }
    }

    private static interface IStringKeys {
        public static final String ERROR = "ErrorDialog.error";
        public static final String UNKNOWN_ERROR = "ErrorDialog.unknownerror";
    }
}

