/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

class ExtraToolTipOnClickDisplay {
    private Popup _currentlyDisplayingPopup;
    private Timer _hideTimer;

    ExtraToolTipOnClickDisplay(JButton btn, boolean atDefaultToolTipPosition, String toolTipText, int displayTimeMillis) {
        btn.addActionListener(e -> this.onTriggerPop(btn, toolTipText, atDefaultToolTipPosition));
        this._hideTimer = new Timer(displayTimeMillis, e -> this.dispose());
    }

    private void onTriggerPop(JButton btn, String toolTipText, boolean atDefaultToolTipPosition) {
        if (null != this._currentlyDisplayingPopup) {
            this.dispose();
            return;
        }
        Point screenLocation = GUIUtils.getScreenLocationFor(btn);
        JToolTip toolTip = new JToolTip();
        toolTip.setTipText(toolTipText);
        toolTip.setComponent(btn);
        this._currentlyDisplayingPopup = atDefaultToolTipPosition ? PopupFactory.getSharedInstance().getPopup(btn, toolTip, screenLocation.x + btn.getWidth(), screenLocation.y + btn.getHeight()) : PopupFactory.getSharedInstance().getPopup(btn, toolTip, screenLocation.x, screenLocation.y - 80);
        this._currentlyDisplayingPopup.show();
        this._hideTimer.setRepeats(false);
        this._hideTimer.start();
    }

    private void dispose() {
        if (null == this._currentlyDisplayingPopup) {
            return;
        }
        this._currentlyDisplayingPopup.hide();
        this._currentlyDisplayingPopup = null;
        this._hideTimer.stop();
    }
}

