/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.fw.gui.CloseByEscapeForDialogWidgetListener;
import net.sourceforge.squirrel_sql.fw.gui.CloseByEscapeListener;
import net.sourceforge.squirrel_sql.fw.gui.ExtraToolTipOnClickDisplay;
import net.sourceforge.squirrel_sql.fw.gui.MouseWheelClickOnTabListener;
import net.sourceforge.squirrel_sql.fw.gui.PropertyCheck;
import net.sourceforge.squirrel_sql.fw.gui.RightMouseClickOnTabListener;
import net.sourceforge.squirrel_sql.fw.gui.ToolTipDisplay;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class GUIUtils {
    private static final ILogger s_log = LoggerController.createLogger(GUIUtils.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GUIUtils.class);
    public static final int TAB_BUTTON_SIDE_LENGTH = 28;

    public static void centerWithinParent(Window wind) {
        Container parent = wind.getParent();
        if (parent != null && parent.isVisible()) {
            GUIUtils.center(wind, new Rectangle(parent.getLocationOnScreen(), parent.getSize()));
        } else {
            GUIUtils.centerWithinScreen(wind);
        }
    }

    public static void centerWithinDesktop(JInternalFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        JDesktopPane parent = frame.getDesktopPane();
        if (parent != null && parent.isVisible()) {
            GUIUtils.center(frame, new Rectangle(new Point(0, 0), parent.getSize()));
        }
    }

    public static void centerWithinScreen(Window wind) {
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        Rectangle rcScreen = new Rectangle(toolKit.getScreenSize());
        Dimension windSize = wind.getSize();
        Dimension parentSize = new Dimension(rcScreen.width, rcScreen.height);
        if (windSize.height > parentSize.height) {
            windSize.height = parentSize.height;
        }
        if (windSize.width > parentSize.width) {
            windSize.width = parentSize.width;
        }
        GUIUtils.center(wind, rcScreen);
    }

    public static void moveToFront(final JInternalFrame fr) {
        if (fr != null) {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    fr.moveToFront();
                    fr.setVisible(true);
                    try {
                        fr.setSelected(true);
                        if (fr.isIcon()) {
                            fr.setIcon(false);
                        }
                        fr.setSelected(true);
                    }
                    catch (PropertyVetoException ex) {
                        s_log.error("Error bringing internal frame to the front", ex);
                    }
                    fr.requestFocus();
                }
            });
        }
    }

    public static Frame getOwningFrame(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException("null Component passed");
        }
        if (comp instanceof Frame) {
            return (Frame)comp;
        }
        return GUIUtils.getOwningFrame(SwingUtilities.windowForComponent(comp));
    }

    public static Window getOwningWindow(Component comp) {
        if (comp instanceof Window) {
            return (Window)comp;
        }
        Dialog owningDialog = GUIUtils._getOwningDialog(comp);
        if (null != owningDialog) {
            return owningDialog;
        }
        return GUIUtils.getOwningFrame(comp);
    }

    private static Dialog _getOwningDialog(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof Dialog) {
            return (Dialog)comp;
        }
        return GUIUtils._getOwningDialog(SwingUtilities.windowForComponent(comp));
    }

    public static boolean isToolWindow(JInternalFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        Object obj = frame.getClientProperty("JInternalFrame.isPalette");
        return obj != null && obj == Boolean.TRUE;
    }

    public static void makeToolWindow(JInternalFrame frame, boolean isToolWindow) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        frame.putClientProperty("JInternalFrame.isPalette", isToolWindow ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void setJButtonSizesTheSame(JButton ... btns) {
        Dimension maxSize = new Dimension(0, 0);
        for (int i = 0; i < btns.length; ++i) {
            JButton btn = btns[i];
            FontMetrics fm = btn.getFontMetrics(btn.getFont());
            Rectangle2D bounds = fm.getStringBounds(btn.getText(), btn.getGraphics());
            int boundsHeight = (int)bounds.getHeight();
            int boundsWidth = (int)bounds.getWidth();
            maxSize.width = boundsWidth > maxSize.width ? boundsWidth : maxSize.width;
            maxSize.height = boundsHeight > maxSize.height ? boundsHeight : maxSize.height;
        }
        Insets insets = btns[0].getInsets();
        maxSize.width += insets.left + insets.right;
        maxSize.height += insets.top + insets.bottom;
        for (int i = 0; i < btns.length; ++i) {
            JButton btn = btns[i];
            btn.setPreferredSize(maxSize);
        }
    }

    public static boolean isWithinParent(Component wind) {
        if (wind == null) {
            throw new IllegalArgumentException("Null Component passed");
        }
        Rectangle windowBounds = wind.getBounds();
        Container parent = wind.getParent();
        Rectangle parentRect = null;
        parentRect = parent != null ? new Rectangle(parent.getSize()) : GUIUtils.getScreenBoundsFor(windowBounds);
        return windowBounds.x >= parentRect.x - 20 && windowBounds.y >= parentRect.y - 20;
    }

    public static Rectangle getScreenBoundsFor(Rectangle rc) {
        GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        ArrayList<GraphicsConfiguration> configs = new ArrayList<GraphicsConfiguration>();
        for (int i = 0; i < gds.length; ++i) {
            GraphicsConfiguration gc = gds[i].getDefaultConfiguration();
            if (!rc.intersects(gc.getBounds())) continue;
            configs.add(gc);
        }
        GraphicsConfiguration selected = null;
        if (configs.size() > 0) {
            for (GraphicsConfiguration gcc : configs) {
                if (selected == null) {
                    selected = gcc;
                    continue;
                }
                if (!gcc.getBounds().contains(rc.x + 20, rc.y + 20)) continue;
                selected = gcc;
                break;
            }
        } else {
            selected = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        int x = selected.getBounds().x;
        int y = selected.getBounds().y;
        int w = selected.getBounds().width;
        int h = selected.getBounds().height;
        return new Rectangle(x, y, w, h);
    }

    public static void processOnSwingEventThread(Runnable todo) {
        GUIUtils.processOnSwingEventThread(todo, false);
    }

    public static void processOnSwingEventThread(Runnable todo, boolean wait) {
        if (todo == null) {
            throw new IllegalArgumentException("Runnable == null");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            todo.run();
            return;
        }
        if (wait) {
            try {
                SwingUtilities.invokeAndWait(todo);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                throw Utilities.wrapRuntime(ex);
            }
        } else {
            SwingUtilities.invokeLater(todo);
        }
    }

    private static void center(Component wind, Rectangle rect) {
        if (wind == null || rect == null) {
            throw new IllegalArgumentException("null Window or Rectangle passed");
        }
        Dimension windSize = wind.getSize();
        int x = (rect.width - windSize.width) / 2 + rect.x;
        int y = (rect.height - windSize.height) / 2 + rect.y;
        if (y < rect.y) {
            y = rect.y;
        }
        wind.setLocation(x, y);
    }

    public static Point getScreenLocationFor(Component component) {
        Component comp = component;
        Point ret = new Point(0, 0);
        while (true) {
            Point buf;
            if (comp instanceof Window) {
                buf = comp.getLocationOnScreen();
                ret.translate(buf.x, buf.y);
                return ret;
            }
            buf = comp.getLocation();
            ret.translate(buf.x, buf.y);
            comp = comp.getParent();
        }
    }

    public static void enableCloseByEscape(JDialog dialog) {
        GUIUtils.enableCloseByEscape(dialog, null);
    }

    public static void enableCloseByEscape(final JDialog dialog, final CloseByEscapeListener closeByEscapeListener) {
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != closeByEscapeListener) {
                    closeByEscapeListener.willCloseByEscape(dialog);
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        dialog.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        dialog.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        dialog.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        dialog.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    public static void enableCloseByEscape(DialogWidget dialogWidget) {
        GUIUtils.enableCloseByEscape(dialogWidget, null);
    }

    public static void enableCloseByEscape(final DialogWidget dialogWidget, final CloseByEscapeForDialogWidgetListener closeByEscapeListener) {
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (null != closeByEscapeListener) {
                    closeByEscapeListener.willCloseByEscape(dialogWidget);
                }
                dialogWidget.setVisible(false);
                dialogWidget.dispose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        dialogWidget.getDelegate().getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        dialogWidget.getDelegate().getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        dialogWidget.getDelegate().getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        dialogWidget.getDelegate().getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    public static DefaultMutableTreeNode createFolderNode(Object userObject) {
        DefaultMutableTreeNode newFolder = new DefaultMutableTreeNode(userObject){

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        return newFolder;
    }

    public static void forceFocus(Component comp) {
        GUIUtils.forceFocus(comp, null);
    }

    public static void forceFocus(Component comp, Runnable callWhenFocused) {
        GUIUtils.forceFocus(comp, callWhenFocused, null);
    }

    public static void forceFocus(final Component comp, final Runnable callWhenFocused, final String logIdentifier) {
        Timer[] timerRef;
        timerRef = new Timer[]{new Timer(100, new ActionListener(){
            private int focusTrialsCount = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean hasFocus = comp.hasFocus();
                if (hasFocus || this.focusTrialsCount > 15) {
                    timerRef[0].stop();
                    if (null != callWhenFocused) {
                        callWhenFocused.run();
                    }
                    if (!StringUtils.isEmpty((CharSequence)logIdentifier)) {
                        String res = hasFocus ? "succeeded" : "failed";
                        s_log.info(logIdentifier + " --> force focus " + res + " after " + (this.focusTrialsCount + 1) + " trials");
                    }
                    return;
                }
                comp.requestFocusInWindow();
                comp.requestFocus();
                ++this.focusTrialsCount;
            }
        })};
        timerRef[0].setRepeats(true);
        timerRef[0].start();
        comp.requestFocusInWindow();
        comp.requestFocus();
    }

    public static void executeDelayed(Runnable runnable) {
        GUIUtils.executeDelayed(runnable, 100);
    }

    public static void executeDelayed(Runnable runnable, int delayMillis) {
        Timer timer = new Timer(delayMillis, e -> runnable.run());
        timer.setRepeats(false);
        timer.start();
    }

    public static void forceProperty(PropertyCheck propertyCheck) {
        GUIUtils.forceProperty(propertyCheck, null);
    }

    public static void forceProperty(PropertyCheck propertyCheck, Runnable callOnFinished) {
        GUIUtils.forceProperty(propertyCheck, callOnFinished, 100);
    }

    public static void forceProperty(final PropertyCheck propertyCheck, final Runnable callOnFinished, int delayMillis) {
        Timer[] timerRef;
        timerRef = new Timer[]{new Timer(delayMillis, new ActionListener(){
            private int maxCount = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (propertyCheck.checkAndSetProperty() || this.maxCount > 15) {
                    timerRef[0].stop();
                    if (null != callOnFinished) {
                        callOnFinished.run();
                    }
                    return;
                }
                ++this.maxCount;
            }
        })};
        timerRef[0].setRepeats(true);
        timerRef[0].start();
        propertyCheck.checkAndSetProperty();
    }

    public static void forceWidth(JComponent comp, int width) {
        GUIUtils.forceProperty(() -> GUIUtils.checkAndForceSize(comp, width));
    }

    private static boolean checkAndForceSize(JComponent comp, int width) {
        GUIUtils.setPreferredWidth(comp, width);
        GUIUtils.setMinimumWidth(comp, width);
        return comp.getSize().width == width;
    }

    public static void forceScrollToBegin(JScrollPane scrollPane) {
        GUIUtils.forceScrollToBegin(scrollPane, 15);
    }

    public static void forceScrollToBegin(final JScrollPane scrollPane, final int maxTrialsCount) {
        Timer[] timerRef;
        timerRef = new Timer[]{new Timer(100, new ActionListener(){
            private int maxCount = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                int hValue = scrollPane.getHorizontalScrollBar().getValue();
                int vValue = scrollPane.getVerticalScrollBar().getValue();
                if (0 == hValue && 0 == vValue || this.maxCount > maxTrialsCount) {
                    timerRef[0].stop();
                    return;
                }
                scrollPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                scrollPane.getHorizontalScrollBar().setValue(0);
                scrollPane.getVerticalScrollBar().setValue(0);
                ++this.maxCount;
            }
        })};
        timerRef[0].setRepeats(true);
        timerRef[0].start();
        scrollPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        scrollPane.getHorizontalScrollBar().setValue(0);
        scrollPane.getVerticalScrollBar().setValue(0);
    }

    public static int getMinHeightOfAllScreens() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        int minHight = Integer.MAX_VALUE;
        for (int j = 0; j < gs.length; ++j) {
            GraphicsDevice gd = gs[j];
            GraphicsConfiguration[] gc = gd.getConfigurations();
            for (int i = 0; i < gc.length; ++i) {
                minHight = Math.min(gc[i].getBounds().height, minHight);
            }
        }
        return minHight;
    }

    public static Rectangle ensureBoundsOnOneScreen(Rectangle rectInScreenCoordinates) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDevices = graphicsEnvironment.getScreenDevices();
        Rectangle screenBounds = new Rectangle();
        int minDx = 0;
        int minDy = 0;
        for (int j = 0; j < graphicsDevices.length; ++j) {
            GraphicsDevice graphicsDevice = graphicsDevices[j];
            screenBounds.setRect(graphicsDevice.getDefaultConfiguration().getBounds());
            screenBounds.setRect(screenBounds.x, screenBounds.y, screenBounds.width, screenBounds.height);
            if (screenBounds.contains(rectInScreenCoordinates)) {
                return rectInScreenCoordinates;
            }
            int dx = screenBounds.x + screenBounds.width - (rectInScreenCoordinates.x + rectInScreenCoordinates.width);
            int dy = screenBounds.y + screenBounds.height - (rectInScreenCoordinates.y + rectInScreenCoordinates.height);
            if (0 == minDx && 0 == minDy) {
                minDx = dx;
                minDy = dy;
                continue;
            }
            if (minDx * minDx + minDy * minDy <= dx * dx + dy * dy) continue;
            minDx = dx;
            minDy = dy;
        }
        if (minDx < 0) {
            rectInScreenCoordinates.x = Math.max(0, rectInScreenCoordinates.x + minDx);
        }
        if (minDy < 0) {
            rectInScreenCoordinates.y = Math.max(0, rectInScreenCoordinates.y + minDy);
        }
        return rectInScreenCoordinates;
    }

    public static <T extends AbstractButton> T styleAsToolbarButton(T btn) {
        return GUIUtils.styleAsToolbarButton(btn, false);
    }

    public static <T extends AbstractButton> T styleAsToolbarButton(T btn, boolean focusable) {
        return GUIUtils.styleAsToolbarButton(btn, focusable, true);
    }

    public static <T extends AbstractButton> T styleAsToolbarButton(final T btn, boolean focusable, boolean bordered) {
        GUIUtils.setButtonContentAreaFilledRespectSelectedToggle(btn, false);
        if (bordered) {
            btn.setBorder(BorderFactory.createEtchedBorder());
        } else {
            btn.setBorder(BorderFactory.createEmptyBorder());
        }
        btn.setFocusable(focusable);
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                GUIUtils.setButtonContentAreaFilledRespectSelectedToggle(btn, true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GUIUtils.setButtonContentAreaFilledRespectSelectedToggle(btn, false);
            }
        });
        if (btn instanceof JToggleButton) {
            btn.addChangeListener(e -> btn.setContentAreaFilled(btn.isSelected() || GUIUtils.isMouseOver(btn)));
        }
        return btn;
    }

    public static <T extends AbstractButton> T styleAsTabButton(T abstractButton) {
        abstractButton.setText("");
        abstractButton.setPreferredSize(new Dimension(28, 28));
        abstractButton.setMinimumSize(new Dimension(28, 28));
        abstractButton.setMaximumSize(new Dimension(28, 28));
        return GUIUtils.styleAsToolbarButton(abstractButton);
    }

    private static boolean isMouseOver(Component component) {
        if (!component.isShowing() || GraphicsEnvironment.isHeadless()) {
            return false;
        }
        GraphicsConfiguration gconf = component.getGraphicsConfiguration();
        PointerInfo mousePointer = MouseInfo.getPointerInfo();
        if (gconf.getDevice() != mousePointer.getDevice()) {
            return false;
        }
        Point location = component.getLocationOnScreen();
        Rectangle bounds = new Rectangle(location.x, location.y, component.getWidth(), component.getHeight());
        return bounds.contains(mousePointer.getLocation());
    }

    private static void setButtonContentAreaFilledRespectSelectedToggle(AbstractButton btn, boolean b) {
        if (btn instanceof JToggleButton && btn.isSelected()) {
            btn.setContentAreaFilled(true);
            return;
        }
        btn.setContentAreaFilled(b);
    }

    public static void listenToMouseWheelClickOnTab(final JTabbedPane tabbedPane, final MouseWheelClickOnTabListener mouseWheelClickOnTabListener) {
        tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GUIUtils.handleMiddleMouseClick(e, tabbedPane, mouseWheelClickOnTabListener);
            }
        });
    }

    public static void listenToRightMouseClickOnTabComponent(final JTabbedPane tabbedPane, final RightMouseClickOnTabListener rightMouseClickOnTabListener) {
        tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GUIUtils.handleRightMouseClick(e, tabbedPane, rightMouseClickOnTabListener);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GUIUtils.handleRightMouseClick(e, tabbedPane, rightMouseClickOnTabListener);
            }
        });
    }

    private static void handleRightMouseClick(MouseEvent e, JTabbedPane tabbedPane, RightMouseClickOnTabListener rightMouseClickOnTabListener) {
        if (!e.isPopupTrigger()) {
            return;
        }
        int tabIndex = tabbedPane.getUI().tabForCoordinate(tabbedPane, e.getX(), e.getY());
        if (-1 != tabIndex) {
            Component tabComponent = tabbedPane.getTabComponentAt(tabIndex);
            if (null == tabComponent) {
                rightMouseClickOnTabListener.rightMouseClickedOnTabComponent(tabIndex, tabbedPane, e.getX(), e.getY());
            } else {
                MouseEvent mouseEventOnTabComponent = SwingUtilities.convertMouseEvent(tabbedPane, e, tabComponent);
                rightMouseClickOnTabListener.rightMouseClickedOnTabComponent(tabIndex, tabComponent, mouseEventOnTabComponent.getX(), mouseEventOnTabComponent.getY());
            }
        }
    }

    private static void handleMiddleMouseClick(MouseEvent e, JTabbedPane tabbedPane, MouseWheelClickOnTabListener mouseWheelClickOnTabListener) {
        int tabIndex;
        if (SwingUtilities.isMiddleMouseButton(e) && -1 != (tabIndex = tabbedPane.getUI().tabForCoordinate(tabbedPane, e.getX(), e.getY()))) {
            mouseWheelClickOnTabListener.mouseWheelClickedOnTabComponent(tabIndex, tabbedPane.getTabComponentAt(tabIndex));
        }
    }

    public static Dimension initLocation(Window window, int defaultWidth, int defaultHeight) {
        String identifier = window.getClass().getName();
        return GUIUtils.initLocation(window, defaultWidth, defaultHeight, identifier);
    }

    public static Dimension initLocation(final Window window, int defaultWidth, int defaultHeight, String identifier) {
        final String widthPropKey = identifier + ".WIDTH";
        final String heightPropKey = identifier + ".HEIGHT";
        Dimension size = new Dimension(Props.getInt(widthPropKey, defaultWidth), Props.getInt(heightPropKey, defaultHeight));
        window.setSize(size);
        GUIUtils.centerWithinParent(window);
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (0 < window.getWidth() && 0 < window.getHeight()) {
                    Props.putInt(widthPropKey, window.getWidth());
                    Props.putInt(heightPropKey, window.getHeight());
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (0 < window.getWidth() && 0 < window.getHeight()) {
                    Props.putInt(widthPropKey, window.getWidth());
                    Props.putInt(heightPropKey, window.getHeight());
                }
            }
        });
        return size;
    }

    public static JTextField styleTextFieldToCopyableLabel(JTextField textField) {
        textField.setEditable(false);
        textField.setBackground(new JPanel().getBackground());
        textField.setBorder(null);
        return textField;
    }

    public static <T extends Component> T setPreferredWidth(T comp, int width) {
        comp.setPreferredSize(new Dimension(width, comp.getPreferredSize().height));
        return comp;
    }

    public static <T extends Component> T setPreferredHeight(T comp, int height) {
        comp.setPreferredSize(new Dimension(comp.getPreferredSize().width, height));
        return comp;
    }

    public static <T extends Component> T setMaximumWidth(T comp, int width) {
        comp.setMaximumSize(new Dimension(width, comp.getMaximumSize().height));
        return comp;
    }

    public static <T extends Component> T setMaximumHeight(T comp, int height) {
        comp.setMaximumSize(new Dimension(comp.getMaximumSize().width, height));
        return comp;
    }

    public static <T extends Component> T setMinimumWidth(T comp, int width) {
        comp.setMinimumSize(new Dimension(width, comp.getMinimumSize().height));
        return comp;
    }

    public static <T extends Component> T setMinimumHeight(T comp, int height) {
        comp.setMinimumSize(new Dimension(comp.getMinimumSize().width, height));
        return comp;
    }

    public static void inheritBackground(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setOpaque(false);
        }
        Color original = comp.isBackgroundSet() ? comp.getBackground() : null;
        Runnable updateBackground = () -> {
            Container parent = comp.getParent();
            comp.setBackground(parent != null && parent.isBackgroundSet() ? parent.getBackground() : original);
        };
        PropertyChangeListener backgroundListener = evt -> updateBackground.run();
        comp.addHierarchyListener(evt -> {
            Container current;
            if ((evt.getChangeFlags() & 1L) == 0L) {
                return;
            }
            if (evt.getChanged() != comp) {
                return;
            }
            Container previous = evt.getChangedParent();
            if (previous != (current = comp.getParent()) && previous != null) {
                previous.removePropertyChangeListener("background", backgroundListener);
            }
            if (current != null) {
                current.addPropertyChangeListener("background", backgroundListener);
                updateBackground.run();
            }
        });
        if (comp.getParent() != null) {
            comp.getParent().addPropertyChangeListener(backgroundListener);
            updateBackground.run();
        }
    }

    public static JPanel createVerticalSeparatorPanel() {
        JPanel separator = new JPanel();
        separator.setPreferredSize(new Dimension(4, separator.getPreferredSize().height));
        separator.setBorder(BorderFactory.createEtchedBorder());
        return separator;
    }

    public static JPanel createHorizontalSeparatorPanel() {
        return GUIUtils.createHorizontalSeparatorPanel(null);
    }

    public static JPanel createHorizontalSeparatorPanel(String title) {
        if (StringUtils.isBlank((CharSequence)title)) {
            JPanel separator = new JPanel(new GridLayout(1, 1));
            separator.add(new JSeparator());
            return separator;
        }
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new JLabel(title), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0);
        ret.add((Component)new JSeparator(), gbc);
        return ret;
    }

    public static Rectangle toRectangle(Rectangle2D in) {
        return new Rectangle((int)in.getX(), (int)in.getY(), (int)in.getWidth(), (int)in.getHeight());
    }

    public static int getMaxStringWidth(JComponent comp, String ... strings) {
        FontMetrics fm = comp.getFontMetrics(comp.getFont());
        int ret = 0;
        for (String str : strings) {
            if (ret >= fm.stringWidth(str)) continue;
            ret = fm.stringWidth(str);
        }
        return ret;
    }

    public static void showExtraToolTipOnClick(JButton btn) {
        GUIUtils.showExtraToolTipOnClick(btn, false, btn.getToolTipText(), ToolTipManager.sharedInstance().getDismissDelay());
    }

    public static void showExtraToolTipOnClick(JButton btn, boolean atDefaultToolTipPosition, String toolTipText, int displayTimeMillis) {
        new ExtraToolTipOnClickDisplay(btn, atDefaultToolTipPosition, toolTipText, displayTimeMillis);
    }

    public static ToolTipDisplay createToolTipDisplay(JComponent parent) {
        return new ToolTipDisplay(parent);
    }

    public static void alignPreferredWidths(JComponent ... components) {
        int maxPreferredWidth = 1;
        for (JComponent component : components) {
            maxPreferredWidth = Math.max(component.getPreferredSize().width, maxPreferredWidth);
        }
        for (JComponent component : components) {
            GUIUtils.setPreferredWidth(component, maxPreferredWidth);
        }
    }

    public static Rectangle getRectangleOfPosition(JTextArea textArea, int position) {
        return GUIUtils.getRectangleOfPosition(textArea, position, null);
    }

    public static Rectangle getRectangleOfPosition(JTextArea textArea, int caretPosition, Position.Bias dotBias) {
        try {
            if (caretPosition < 0) {
                return new Rectangle(0, 0, 1, 1);
            }
            if (caretPosition >= textArea.getText().length()) {
                return new Rectangle(textArea.getWidth(), textArea.getHeight(), 1, 1);
            }
            TextUI mapper = textArea.getUI();
            Rectangle r = mapper.modelToView2D(textArea, caretPosition, dotBias).getBounds();
            return r;
        }
        catch (BadLocationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public static <T> List<T> getListItems(DefaultListModel<T> listModel) {
        ArrayList<T> ret = new ArrayList<T>();
        Enumeration<T> e = listModel.elements();
        while (e.hasMoreElements()) {
            ret.add(e.nextElement());
        }
        return ret;
    }

    public static JPanel createButtonBar(JButton ... buttons) {
        JPanel ret = new JPanel(new BorderLayout());
        ret.add((Component)new JPanel(), "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, buttons.length, 5, 0));
        for (JButton button : buttons) {
            buttonPanel.add(button);
        }
        ret.add((Component)buttonPanel, "East");
        return ret;
    }
}

