/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.gui.RectangleSelectionListener;

public class RectangleSelectionHandler {
    private JComponent _comp;
    private Point _dragBeginPoint = null;
    private Point _dragEndPoint = null;
    private RectangleSelectionListener _rectangleSelectionListener;
    private boolean _cancelCurrentSelection;

    public RectangleSelectionHandler(JComponent comp) {
        this.setComponent(comp);
    }

    public RectangleSelectionHandler() {
    }

    private void onMouseDragged(MouseEvent e) {
        if (null == this._dragBeginPoint) {
            this.initBeginPoint(e);
        }
        this._dragEndPoint = e.getPoint();
        this._comp.repaint();
    }

    public void paintRectWhenNeeded(Graphics g) {
        if (!this._cancelCurrentSelection && null != this._dragBeginPoint && null != this._dragEndPoint && !this._dragBeginPoint.equals(this._dragEndPoint)) {
            int x = Math.min(this._dragBeginPoint.x, this._dragEndPoint.x);
            int y = Math.min(this._dragBeginPoint.y, this._dragEndPoint.y);
            int width = Math.abs(this._dragBeginPoint.x - this._dragEndPoint.x);
            int heigh = Math.abs(this._dragBeginPoint.y - this._dragEndPoint.y);
            Color colBuf = g.getColor();
            g.setColor(this._comp.getForeground());
            g.drawRect(x, y, width, heigh);
            g.setColor(colBuf);
        }
    }

    public void setComponent(JComponent comp) {
        this._comp = comp;
        this._comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                RectangleSelectionHandler.this.initBeginPoint(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                RectangleSelectionHandler.this.onMouseReleased();
            }
        });
        this._comp.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                RectangleSelectionHandler.this.onMouseDragged(e);
            }
        });
    }

    private void onMouseReleased() {
        if (!this._cancelCurrentSelection && null != this._rectangleSelectionListener && null != this._dragBeginPoint && null != this._dragEndPoint) {
            this._rectangleSelectionListener.rectSelected(this._dragBeginPoint, this._dragEndPoint);
        }
        this._dragBeginPoint = null;
        this._dragEndPoint = null;
        this._cancelCurrentSelection = false;
        this._comp.repaint();
    }

    private void initBeginPoint(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && 0 == (e.getModifiersEx() & 0x80)) {
            this._dragBeginPoint = e.getPoint();
        }
    }

    public void setRectangleSelectionListener(RectangleSelectionListener rectangleSelectionListener) {
        this._rectangleSelectionListener = rectangleSelectionListener;
    }

    public static boolean rectHit(Rectangle bounds, Point p1, Point p2) {
        Rectangle selRect = new Rectangle(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p1.x - p2.x), Math.abs(p1.y - p2.y));
        return bounds.intersects(selRect);
    }

    public void cancelCurrentSelection() {
        this._cancelCurrentSelection = true;
    }
}

