/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.ResizableTextEditDialogBeforeOkCloseCallback;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ResizableTextEditDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResizableTextEditDialog.class);
    private JTextField _txtEditedText = new JTextField();
    private JButton _btnOk;
    private JButton _btnCancel;
    private boolean _ok;

    public ResizableTextEditDialog(Window parentFrame, String originKey, String dialogTitle, String textFieldLabel, String initialEditText) {
        this(parentFrame, originKey, dialogTitle, textFieldLabel, initialEditText, null);
    }

    public ResizableTextEditDialog(Window parentFrame, String originKey, String dialogTitle, String textFieldLabel, String initialEditText, ResizableTextEditDialogBeforeOkCloseCallback okCloseCallback) {
        super(parentFrame, dialogTitle, Dialog.ModalityType.APPLICATION_MODAL);
        this.layoutUI(initialEditText, textFieldLabel);
        this._btnOk.addActionListener(e -> this.onOk(okCloseCallback));
        this._btnCancel.addActionListener(e -> this.close());
        this.getRootPane().setDefaultButton(this._btnOk);
        GUIUtils.enableCloseByEscape(this);
        GUIUtils.initLocation(this, 450, 140, originKey);
        GUIUtils.forceFocus(this._txtEditedText);
        this.setVisible(true);
    }

    private void onOk(ResizableTextEditDialogBeforeOkCloseCallback okCloseCallback) {
        if (StringUtilities.isEmpty(this._txtEditedText.getText(), true)) {
            JOptionPane.showMessageDialog(this, s_stringMgr.getString("ResizableTextEditDialog.empty.name"));
            return;
        }
        if (null != okCloseCallback && !okCloseCallback.allowCloseOnOk(this, this._txtEditedText.getText().trim())) {
            return;
        }
        this._ok = true;
        this.close();
    }

    public boolean isOk() {
        return this._ok;
    }

    public String getEditedText() {
        return this._txtEditedText.getText().trim();
    }

    public void setOk(boolean ok) {
        this._ok = ok;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void layoutUI(String savedSessionNameTemplate, String textFieldLabel) {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 10), 0, 0);
        this.getContentPane().add((Component)new JLabel(textFieldLabel), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 10, 0, 10), 0, 0);
        this._txtEditedText.setText(savedSessionNameTemplate);
        this.getContentPane().add((Component)this._txtEditedText, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 10, 10, 10), 0, 0);
        this.getContentPane().add((Component)this.createOkCancelPanel(), gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0);
        this.getContentPane().add((Component)new JPanel(), gbc);
    }

    private JPanel createOkCancelPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        this._btnOk = new JButton(s_stringMgr.getString("ResizableTextEditDialog.ok"));
        ret.add((Component)this._btnOk, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0);
        this._btnCancel = new JButton(s_stringMgr.getString("ResizableTextEditDialog.cancel"));
        ret.add((Component)this._btnCancel, gbc);
        return ret;
    }
}

