/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class ToggleComponentHolder {
    private ArrayList<AbstractButton> _toggleables = new ArrayList();
    private boolean _selected;

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean b) {
        this._selected = b;
        for (int i = 0; i < this._toggleables.size(); ++i) {
            AbstractButton abstractButton = this._toggleables.get(i);
            GUIUtils.processOnSwingEventThread(() -> abstractButton.setSelected(this._selected));
        }
    }

    public void addToggleableComponent(AbstractButton toggleable) {
        this.addToggleableComponent(toggleable, null);
    }

    public void addToggleableComponent(AbstractButton toggleable, ISession session) {
        Action origAction = toggleable.getAction();
        if (null == origAction) {
            throw new RuntimeException("No Action attached to button");
        }
        KeyStroke accelerator = null;
        if (toggleable instanceof JMenuItem) {
            accelerator = ((JMenuItem)toggleable).getAccelerator();
        }
        toggleable.setAction(new ActionProxy(origAction));
        if (null != accelerator) {
            ((JMenuItem)toggleable).setAccelerator(accelerator);
        }
        this._toggleables.add(toggleable);
        if (null != session) {
            session.addSimpleSessionListener(() -> this._toggleables.remove(toggleable));
        }
    }

    private void selectionChanged() {
        this._selected = !this._selected;
        for (int i = 0; i < this._toggleables.size(); ++i) {
            AbstractButton abstractButton = this._toggleables.get(i);
            abstractButton.setSelected(this._selected);
        }
    }

    public void doClick() {
        this._toggleables.get(0).doClick();
    }

    private class ActionProxy
    implements Action {
        private Action _delegate;

        ActionProxy(Action delegate) {
            this._delegate = delegate;
        }

        @Override
        public boolean isEnabled() {
            return this._delegate.isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            this._delegate.setEnabled(b);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this._delegate.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this._delegate.removePropertyChangeListener(listener);
        }

        @Override
        public Object getValue(String key) {
            return this._delegate.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this._delegate.putValue(key, value);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToggleComponentHolder.this.selectionChanged();
            this._delegate.actionPerformed(e);
        }
    }
}

