/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.IToggleAction;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ToolBar
extends JToolBar {
    private static ILogger s_log = LoggerController.createLogger(ToolBar.class);

    public ToolBar() {
    }

    public ToolBar(int orientation) {
        super(orientation);
    }

    @Override
    public JButton add(Action action) {
        JButton btn = super.add(action);
        this.initialiseButton(action, btn);
        return btn;
    }

    public void remove(Action action) {
        for (Component component : super.getComponents()) {
            AbstractButton btn;
            if (!(component instanceof AbstractButton) || !action.equals((btn = (AbstractButton)component).getAction())) continue;
            this.remove(btn);
            this.invalidate();
            this.doLayout();
            this.repaint();
            return;
        }
    }

    public JToggleButton addToggleAction(IToggleAction action) {
        return this.addToggleAction(action, null);
    }

    public JToggleButton addToggleAction(IToggleAction action, ISession session) {
        JToggleButton tglBtn = new JToggleButton();
        tglBtn.setAction(action);
        super.add(tglBtn);
        action.getToggleComponentHolder().addToggleableComponent(tglBtn, session);
        this.initialiseButton(action, tglBtn);
        return tglBtn;
    }

    public AbstractButton add(Action action, AbstractButton btn) {
        btn.setAction(action);
        super.add(btn);
        this.initialiseButton(action, btn);
        return btn;
    }

    public void setUseRolloverButtons(boolean value) {
        this.putClientProperty("JToolBar.isRollover", value ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void initialiseButton(Action action, AbstractButton btn) {
        if (btn == null) {
            return;
        }
        btn.setRequestFocusEnabled(false);
        btn.setText("");
        if (action != null) {
            Object toolTip = (String)action.getValue("ShortDescription");
            toolTip = StringUtilities.isEmpty((String)toolTip, true) ? "" : ((String)toolTip).trim();
            if (null != action.getValue("SQuirreLAcceleratorString") && 0 != action.getValue("SQuirreLAcceleratorString").toString().trim().length()) {
                String accelleratorString = "(" + action.getValue("SQuirreLAcceleratorString") + ")";
                if (!((String)toolTip).trim().toLowerCase().endsWith(accelleratorString.toLowerCase())) {
                    toolTip = (String)toolTip + " " + accelleratorString;
                }
            }
            btn.setToolTipText((String)toolTip);
        }
        if (action != null) {
            Icon icon = this.getIconFromAction(action, "squirrelRolloverIcon");
            if (icon != null) {
                btn.setRolloverIcon(icon);
                btn.setRolloverSelectedIcon(icon);
            }
            if ((icon = this.getIconFromAction(action, "squirrelDisabledIcon")) != null) {
                btn.setDisabledIcon(icon);
            }
            this.mapInputAction(action, btn);
        }
    }

    protected void mapInputAction(Action action) {
        this.mapInputAction(action, this);
    }

    protected void mapInputAction(Action action, JComponent component) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke == null) {
            return;
        }
        Object command = action.getValue("ActionCommandKey");
        if (command == null) {
            command = action.getClass().getName();
        }
        component.getActionMap().put(command, action);
        component.getInputMap(2).put(keyStroke, command);
    }

    protected Icon getIconFromAction(Action action, String key) {
        Object obj = action.getValue(key);
        if (obj != null) {
            if (obj instanceof Icon) {
                return (Icon)obj;
            }
            StringBuffer msg = new StringBuffer();
            msg.append("Non icon object of type ").append(obj.getClass().getName()).append(" was stored in an Action of type ").append(action.getClass().getName()).append(" using the key ").append(key).append(".");
            s_log.error(msg.toString());
        }
        return null;
    }
}

