/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class ToolTipDisplay {
    private final JComponent _parent;
    private Popup _currentlyDisplayingPopup;
    private Timer _hideTimer;

    public ToolTipDisplay(JComponent parent) {
        this(parent, ToolTipManager.sharedInstance().getDismissDelay());
    }

    public ToolTipDisplay(JComponent parent, int displayTimeMillis) {
        this._parent = parent;
        this._hideTimer = new Timer(displayTimeMillis, e -> this.closeToolTip());
    }

    public void displayToolTip(int xRelativeToParent, int yRelativeToParent, String toolTipText) {
        if (null != this._currentlyDisplayingPopup) {
            this.closeToolTip();
        }
        if (StringUtilities.isEmpty(toolTipText, true)) {
            return;
        }
        Point parentScreenLocation = GUIUtils.getScreenLocationFor(this._parent);
        JToolTip toolTip = new JToolTip();
        toolTip.setTipText(toolTipText);
        toolTip.setComponent(this._parent);
        this._currentlyDisplayingPopup = PopupFactory.getSharedInstance().getPopup(this._parent, toolTip, parentScreenLocation.x + xRelativeToParent, parentScreenLocation.y + yRelativeToParent);
        this._currentlyDisplayingPopup.show();
        this._hideTimer.setRepeats(false);
        this._hideTimer.start();
    }

    public void displayToolTip(int xRelativeToParent, int yRelativeToParent, String toolTipText, Object displayMark) {
        if (null != this._currentlyDisplayingPopup) {
            this.closeToolTip();
        }
        Point parentScreenLocation = GUIUtils.getScreenLocationFor(this._parent);
        JToolTip toolTip = new JToolTip();
        toolTip.setTipText(toolTipText);
        toolTip.setComponent(this._parent);
        this._currentlyDisplayingPopup = PopupFactory.getSharedInstance().getPopup(this._parent, toolTip, parentScreenLocation.x + xRelativeToParent, parentScreenLocation.y + yRelativeToParent);
        this._currentlyDisplayingPopup.show();
        this._hideTimer.setRepeats(false);
        this._hideTimer.start();
    }

    public void closeToolTip() {
        if (null == this._currentlyDisplayingPopup) {
            return;
        }
        this._currentlyDisplayingPopup.hide();
        this._currentlyDisplayingPopup = null;
        this._hideTimer.stop();
    }
}

