/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TooManyListenersException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.fw.gui.TreeDnDHandlerCallback;
import net.sourceforge.squirrel_sql.fw.gui.TreeDndDropPosition;
import net.sourceforge.squirrel_sql.fw.gui.TreeDndDropPositionData;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class TreeDnDHandler {
    private JTree _tree;
    private TreeDnDHandlerCallback _treeDnDHandlerCallback;
    private boolean _allowExternalDrop;

    public TreeDnDHandler(JTree tree, TreeDnDHandlerCallback treeDnDHandlerCallback) {
        this(tree, treeDnDHandlerCallback, false);
    }

    public TreeDnDHandler(JTree tree, TreeDnDHandlerCallback treeDnDHandlerCallback, boolean allowExternalDrop) {
        this._tree = tree;
        this._treeDnDHandlerCallback = treeDnDHandlerCallback;
        this._allowExternalDrop = allowExternalDrop;
        this.initDnD();
    }

    private void initDnD() {
        try {
            this._tree.setDragEnabled(true);
            DropTarget dt = new DropTarget();
            dt.addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    TreeDnDHandler.this._treeDnDHandlerCallback.updateDragPosition(TreeDndDropPositionData.empty());
                    TreeDnDHandler.this.onDrop(dtde);
                }

                @Override
                public void dragEnter(DropTargetDragEvent dtde) {
                    TreeDnDHandler.this._treeDnDHandlerCallback.updateDragPosition(TreeDnDHandler.this.getTreeDndDropPositionData(dtde.getLocation()));
                }

                @Override
                public void dragOver(DropTargetDragEvent dtde) {
                    TreeDnDHandler.this._treeDnDHandlerCallback.updateDragPosition(TreeDnDHandler.this.getTreeDndDropPositionData(dtde.getLocation()));
                }

                @Override
                public void dragExit(DropTargetEvent dte) {
                    TreeDnDHandler.this._treeDnDHandlerCallback.updateDragPosition(TreeDndDropPositionData.empty());
                }
            });
            this._tree.setDropTarget(dt);
        }
        catch (TooManyListenersException e) {
            throw new RuntimeException(e);
        }
    }

    private void onDrop(DropTargetDropEvent dtde) {
        try {
            TreePath[] toPaste;
            TreeDndDropPositionData treeDndDropPositionData = this.getTreeDndDropPositionData(dtde.getLocation());
            TreePath targetPath = treeDndDropPositionData.getTreePath();
            if (!dtde.isLocalTransfer()) {
                if (!this._allowExternalDrop) {
                    return;
                }
                ArrayList<DefaultMutableTreeNode> nodes = this._treeDnDHandlerCallback.getPasteTreeNodesFromExternalTransfer(dtde, targetPath);
                ArrayList<TreePath> buf = new ArrayList<TreePath>();
                for (DefaultMutableTreeNode node : nodes) {
                    buf.add(new TreePath(node));
                }
                toPaste = buf.toArray(new TreePath[0]);
            } else {
                toPaste = this._treeDnDHandlerCallback.getPasteTreeNodesFromInternalTransfer(dtde, targetPath, this._tree.getSelectionPaths());
            }
            if (0 != (3 & dtde.getDropAction())) {
                this.execCopyOrMove(toPaste, treeDndDropPositionData);
                this._treeDnDHandlerCallback.dndExecuted();
            }
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private boolean isPlaceAbove(DropTargetDropEvent dtde) {
        return this.isPlaceAbove(dtde.getLocation());
    }

    private boolean isPlaceAbove(Point location) {
        int row = this._tree.getRowForLocation(location.x, location.y);
        if (-1 == row) {
            return false;
        }
        Rectangle rowBounds = this._tree.getRowBounds(row);
        int distToTopOfRow = Math.abs(rowBounds.y - location.y);
        return distToTopOfRow * 4 < rowBounds.height;
    }

    public void execCopyOrMove(TreePath[] pathsToPaste, TreeDndDropPositionData treeDndDropPositionData) {
        DefaultTreeModel dtm = (DefaultTreeModel)this._tree.getModel();
        ArrayList<Object> cutNodes = new ArrayList();
        if (null == treeDndDropPositionData.getTreePath()) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
            if (this._treeDnDHandlerCallback.nodeAcceptsKids(root)) {
                cutNodes = this.cutDraggedNodes(pathsToPaste, null, dtm);
                int[] childIndices = new int[cutNodes.size()];
                for (int i = 0; i < cutNodes.size(); ++i) {
                    childIndices[i] = root.getChildCount();
                    root.add((MutableTreeNode)cutNodes.get(i));
                }
                dtm.nodesWereInserted(root, childIndices);
            }
        } else {
            cutNodes = this.cutDraggedNodes(pathsToPaste, treeDndDropPositionData.getTreePath(), dtm);
            DefaultMutableTreeNode targetNode = treeDndDropPositionData.getNode();
            switch (treeDndDropPositionData.getPos()) {
                case INTO_ROOT: {
                    for (int i = 0; i < cutNodes.size(); ++i) {
                        targetNode.add((MutableTreeNode)cutNodes.get(i));
                        dtm.nodesWereInserted(targetNode, new int[]{targetNode.getChildCount() - 1});
                    }
                    break;
                }
                case INTO: {
                    for (int i = 0; i < cutNodes.size(); ++i) {
                        targetNode.insert((MutableTreeNode)cutNodes.get(i), 0);
                        dtm.nodesWereInserted(targetNode, new int[]{0});
                    }
                    break;
                }
                case ABOVE: {
                    DefaultMutableTreeNode parent1 = (DefaultMutableTreeNode)targetNode.getParent();
                    int index1 = parent1.getIndex(targetNode);
                    ArrayList<Object> reverted1 = new ArrayList<Object>(cutNodes);
                    Collections.reverse(reverted1);
                    for (int i = 0; i < reverted1.size(); ++i) {
                        parent1.insert((MutableTreeNode)cutNodes.get(i), index1);
                        dtm.nodesWereInserted(parent1, new int[]{index1});
                    }
                    break;
                }
                case BELOW: {
                    DefaultMutableTreeNode parent2 = (DefaultMutableTreeNode)targetNode.getParent();
                    int index2 = parent2.getIndex(targetNode) + 1;
                    ArrayList<Object> reverted2 = new ArrayList<Object>(cutNodes);
                    Collections.reverse(reverted2);
                    for (int i = 0; i < reverted2.size(); ++i) {
                        parent2.insert((MutableTreeNode)cutNodes.get(i), index2);
                        dtm.nodesWereInserted(parent2, new int[]{index2});
                    }
                    break;
                }
            }
        }
        TreePath[] newSelPaths = new TreePath[cutNodes.size()];
        for (int i = 0; i < newSelPaths.length; ++i) {
            newSelPaths[i] = new TreePath(((DefaultMutableTreeNode)cutNodes.get(i)).getPath());
        }
        this._tree.setSelectionPaths(newSelPaths);
    }

    private ArrayList<DefaultMutableTreeNode> cutDraggedNodes(TreePath[] pathsToPaste, TreePath targetPath, DefaultTreeModel dtm) {
        ArrayList<DefaultMutableTreeNode> cutNodes = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < pathsToPaste.length; ++i) {
            if (pathsToPaste[i].equals(targetPath)) continue;
            DefaultMutableTreeNode cutNode = (DefaultMutableTreeNode)pathsToPaste[i].getLastPathComponent();
            cutNodes.add(cutNode);
            if (null == cutNode.getParent()) continue;
            dtm.removeNodeFromParent(cutNode);
        }
        return cutNodes;
    }

    public TreeDndDropPositionData getTreeDndDropPositionData(Point pos) {
        TreePath targetPath = this._tree.getClosestPathForLocation(pos.x, pos.y);
        if (null == targetPath || ((DefaultMutableTreeNode)targetPath.getLastPathComponent()).isRoot()) {
            DefaultTreeModel dtm = (DefaultTreeModel)this._tree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
            if (this._treeDnDHandlerCallback.nodeAcceptsKids(root)) {
                return new TreeDndDropPositionData(root, TreeDndDropPosition.INTO_ROOT);
            }
            throw new IllegalStateException("Root does not allow kids.");
        }
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)targetPath.getLastPathComponent();
        int row = this._tree.getRowForPath(targetPath);
        Rectangle rowBounds = this._tree.getRowBounds(row);
        int distToTopOfRow = Math.abs(rowBounds.y - pos.y);
        int distToBottomOfRow = Math.abs(rowBounds.y + rowBounds.height - pos.y);
        if (this._treeDnDHandlerCallback.nodeAcceptsKids(targetNode)) {
            TreeDndDropPosition treeDndDropPosition = TreeDndDropPosition.INTO;
            if (distToTopOfRow * 4 < rowBounds.height) {
                treeDndDropPosition = TreeDndDropPosition.ABOVE;
            } else if (distToBottomOfRow * 4 < rowBounds.height) {
                treeDndDropPosition = TreeDndDropPosition.BELOW;
            }
            return new TreeDndDropPositionData(targetNode, treeDndDropPosition);
        }
        TreeDndDropPosition treeDndDropPosition = TreeDndDropPosition.ABOVE;
        if (distToTopOfRow > distToBottomOfRow) {
            treeDndDropPosition = TreeDndDropPosition.BELOW;
        }
        return new TreeDndDropPositionData(targetNode, treeDndDropPosition);
    }
}

