/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import javax.swing.JInternalFrame;
import net.sourceforge.squirrel_sql.fw.util.beanwrapper.RectangleWrapper;
import net.sourceforge.squirrel_sql.fw.xml.IXMLAboutToBeWritten;

public class WindowState
implements IXMLAboutToBeWritten,
Serializable {
    private Window _window;
    private JInternalFrame _internalFrame;
    private Frame _frame;
    private RectangleWrapper _bounds = new RectangleWrapper(new Rectangle(600, 400));
    private boolean _visible = true;
    private int _frameExtendedState = 0;

    public WindowState() {
    }

    public WindowState(Window window) {
        this._window = window;
    }

    public WindowState(JInternalFrame internalFrame) {
        this._internalFrame = internalFrame;
    }

    public WindowState(Frame frame) {
        this._frame = frame;
    }

    public void copyFrom(WindowState obj) {
        if (obj == null) {
            throw new IllegalArgumentException("WindowState == null");
        }
        this.setBounds(obj.getBounds());
        this.setVisible(obj.isVisible());
        this.setFrameExtendedState(obj.getFrameExtendedState());
    }

    @Override
    public void aboutToBeWritten() {
        this.refresh();
    }

    public RectangleWrapper getBounds() {
        this.refresh();
        return this._bounds;
    }

    public void setBounds(RectangleWrapper value) {
        this._bounds = value;
        this._window = null;
        this._internalFrame = null;
    }

    public boolean isVisible() {
        this.refresh();
        return this._visible;
    }

    public void setVisible(boolean value) {
        this._visible = value;
    }

    public int getFrameExtendedState() {
        this.refresh();
        return this._frameExtendedState;
    }

    public void setFrameExtendedState(int value) {
        this._frameExtendedState = value;
    }

    private void refresh() {
        Rectangle windRc = null;
        if (this._window != null) {
            windRc = this._window.getBounds();
            this._visible = this._window.isVisible();
        } else if (this._internalFrame != null) {
            windRc = this._internalFrame.getBounds();
            this._visible = this._internalFrame.isVisible();
        } else if (this._frame != null) {
            windRc = this._frame.getBounds();
            this._visible = this._frame.isVisible();
            this._frameExtendedState = this._frame.getExtendedState();
        }
        if (windRc != null) {
            if (this._bounds == null) {
                this._bounds = new RectangleWrapper();
            }
            this._bounds.setFrom(windRc);
        }
    }

    public static interface IPropertyNames {
        public static final String BOUNDS = "bounds";
        public static final String FRAME_EXTENDED_STATE = "frameExtendedState";
        public static final String VISIBLE = "visible";
    }
}

