/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultMetaDataTable;
import net.sourceforge.squirrel_sql.fw.gui.action.InStatColumnInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.ShowReferencesUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.ReferencesFrameStarter;
import net.sourceforge.squirrel_sql.fw.gui.action.showreferences.RootTable;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ShowReferencesCommand {
    static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ShowReferencesCommand.class);
    private final JTable _table;
    private final IDataSetUpdateableModel _updateableModel;
    private JFrame _owningFrame;
    private ISession _session;

    public ShowReferencesCommand(JTable table, IDataSetUpdateableModel updateableModel, JFrame owningFrame, ISession session) {
        this._table = table;
        this._updateableModel = updateableModel;
        this._owningFrame = owningFrame;
        this._session = session;
    }

    public void execute() {
        ResultMetaDataTable fallbackTable = this.tryGetFallbackTableFromUpdatableTableModel(this._updateableModel);
        ArrayList<InStatColumnInfo> inStatColumnInfos = new TableCopyInStatementCommand(this._table, this._session).getInStatColumnInfos();
        List<ResultMetaDataTable> tablesOfSelectedCols = ShowReferencesUtil.findTables(inStatColumnInfos);
        if (null == fallbackTable && tablesOfSelectedCols.isEmpty()) {
            JOptionPane.showMessageDialog(this._owningFrame, s_stringMgr.getString("ShowReferencesCommand.noTable"));
            return;
        }
        if (1 < tablesOfSelectedCols.size()) {
            JOptionPane.showMessageDialog(this._owningFrame, s_stringMgr.getString("ShowReferencesCommand.non.unique.table"));
            return;
        }
        ResultMetaDataTable foreignKeysRefDialogRootTable = fallbackTable;
        if (!tablesOfSelectedCols.isEmpty()) {
            foreignKeysRefDialogRootTable = tablesOfSelectedCols.get(0);
        }
        ReferencesFrameStarter.showReferences(new RootTable(foreignKeysRefDialogRootTable, inStatColumnInfos), this._session, this._owningFrame);
    }

    private ResultMetaDataTable tryGetFallbackTableFromUpdatableTableModel(IDataSetUpdateableModel updateableModel) {
        ITableInfo ti;
        ResultMetaDataTable ret = null;
        if (updateableModel instanceof IDataSetUpdateableTableModel && null != (ti = ((IDataSetUpdateableTableModel)updateableModel).getTableInfo())) {
            ret = new ResultMetaDataTable(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
        }
        return ret;
    }
}

