/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.ResultAsText;
import net.sourceforge.squirrel_sql.fw.datasetviewer.textdataset.ResultAsTextLineCallback;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TableCopyAlignedCommand {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableCopyAlignedCommand.class);
    private JTable _table;
    private ISession _session;

    public TableCopyAlignedCommand(JTable table, ISession session) {
        this._session = session;
        this._table = table;
    }

    public void execute() {
        int nbrSelRows = this._table.getSelectedRowCount();
        int nbrSelCols = this._table.getSelectedColumnCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions = new ArrayList<ColumnDisplayDefinition>();
        for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
            TableColumn col = this._table.getColumnModel().getColumn(selCols[colIdx]);
            if (!(col instanceof ExtTableColumn)) {
                this._session.showErrorMessage(s_stringMgr.getString("TableCopyAlignedCommand.failed.to.copy"));
                return;
            }
            columnDisplayDefinitions.add(((ExtTableColumn)col).getColumnDisplayDefinition());
        }
        ColumnDisplayDefinition[] colDefs = columnDisplayDefinitions.toArray(new ColumnDisplayDefinition[columnDisplayDefinitions.size()]);
        StringBuffer text = new StringBuffer();
        ResultAsTextLineCallback resultAsTextLineCallback = line -> text.append(line);
        ResultAsText resultAsText = new ResultAsText(colDefs, true, resultAsTextLineCallback);
        for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
            Object[] row = new Object[colDefs.length];
            int curIx = 0;
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                Object cellObj;
                row[curIx] = cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                ++curIx;
            }
            resultAsText.addRow(row);
        }
        resultAsText.close();
        ClipboardUtil.copyToClip(text);
    }
}

