/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableClickPosition;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class TableCopyColumnHeaderCommand
implements ICommand {
    private DataSetViewerTablePanel _dataSetViewerTablePanel;
    private TableClickPosition _currentTableClickPosition;

    public TableCopyColumnHeaderCommand(DataSetViewerTablePanel dataSetViewerTablePanel, TableClickPosition currentTableClickPosition) {
        this._dataSetViewerTablePanel = dataSetViewerTablePanel;
        this._currentTableClickPosition = currentTableClickPosition;
    }

    @Override
    public void execute() {
        if (this._currentTableClickPosition.isClickedOnTableHeader()) {
            int columnIndexAtX;
            TableColumnModel cm = this._dataSetViewerTablePanel.getTable().getColumnModel();
            Object headerValue = cm.getColumn(columnIndexAtX = cm.getColumnIndexAtX(this._currentTableClickPosition.getX())).getHeaderValue();
            if (null != headerValue && !StringUtilities.isEmpty("" + headerValue, true)) {
                ClipboardUtil.copyToClip("" + headerValue);
            }
        } else {
            int nbrSelCols = this._dataSetViewerTablePanel.getTable().getSelectedColumnCount();
            int[] selCols = this._dataSetViewerTablePanel.getTable().getSelectedColumns();
            if (0 == selCols.length) {
                return;
            }
            StringBuilder buf = new StringBuilder();
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                TableColumn col = this._dataSetViewerTablePanel.getTable().getColumnModel().getColumn(selCols[colIdx]);
                if (0 == buf.length()) {
                    buf.append(col.getHeaderValue());
                    continue;
                }
                buf.append("," + col.getHeaderValue());
            }
            ClipboardUtil.copyToClip(buf);
        }
    }
}

