/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.SquirrelTableCellRenderer;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class TableCopyCommand
implements ICommand {
    private static final String NULL_CELL = "<null>";
    private JTable _table;
    private boolean _withHeaders;

    public TableCopyCommand(JTable table, boolean withHeaders) {
        if (table == null) {
            throw new IllegalArgumentException("JTable == null");
        }
        this._table = table;
        this._withHeaders = withHeaders;
    }

    @Override
    public void execute() {
        int nbrSelRows = this._table.getSelectedRowCount();
        int nbrSelCols = this._table.getSelectedColumnCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        if (selRows.length != 0 && selCols.length != 0) {
            StringBuffer buf = new StringBuffer();
            if (this._withHeaders) {
                for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                    buf.append(this._table.getColumnName(selCols[colIdx]));
                    if (colIdx >= nbrSelCols - 1) continue;
                    buf.append('\t');
                }
                buf.append('\n');
            }
            for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
                for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                    TableCellRenderer cellRenderer = this._table.getCellRenderer(selRows[rowIdx], selCols[colIdx]);
                    Object cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                    if (cellRenderer instanceof SquirrelTableCellRenderer) {
                        cellObj = ((SquirrelTableCellRenderer)((Object)cellRenderer)).renderValue(cellObj);
                    }
                    buf.append(cellObj != null ? cellObj : NULL_CELL);
                    if (nbrSelCols <= 1 || colIdx >= nbrSelCols - 1) continue;
                    buf.append('\t');
                }
                if (nbrSelRows <= 1) continue;
                buf.append('\n');
            }
            ClipboardUtil.copyToClip(buf);
        }
    }
}

