/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.InStatColumnInfo;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopySqlPartCommandBase;
import net.sourceforge.squirrel_sql.fw.util.ICommand;

public class TableCopyInStatementCommand
extends TableCopySqlPartCommandBase
implements ICommand {
    private JTable _table;

    public TableCopyInStatementCommand(JTable table, ISession session) {
        super(session);
        if (table == null) {
            throw new IllegalArgumentException("JTable == null");
        }
        this._table = table;
    }

    @Override
    public void execute() {
        ArrayList<InStatColumnInfo> inStatColumnInfos = this.getInStatColumnInfos();
        if (0 == inStatColumnInfos.size()) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (InStatColumnInfo inStatColumnInfo : inStatColumnInfos) {
            buf.append(inStatColumnInfo.getInstat()).append("\n");
        }
        ClipboardUtil.copyToClip(buf);
    }

    public ArrayList<InStatColumnInfo> getInStatColumnInfos() {
        return this.getInStatColumnInfos(false);
    }

    public ArrayList<InStatColumnInfo> getInStatColumnInfos(boolean firstLineAllColumns) {
        ArrayList<InStatColumnInfo> ret = new ArrayList<InStatColumnInfo>();
        int nbrSelRows = this._table.getSelectedRowCount();
        int nbrSelCols = this._table.getSelectedColumnCount();
        int[] selRows = this._table.getSelectedRows();
        int[] selCols = this._table.getSelectedColumns();
        if (firstLineAllColumns && 0 < this._table.getRowCount()) {
            nbrSelRows = 1;
            nbrSelCols = 1;
            selRows = new int[]{0};
            selCols = new int[this._table.getColumnModel().getColumnCount()];
            for (int i = 0; i < selCols.length; ++i) {
                selCols[i] = i;
            }
        }
        if (selRows.length != 0 && selCols.length != 0) {
            for (int colIdx = 0; colIdx < nbrSelCols; ++colIdx) {
                TableColumn col = this._table.getColumnModel().getColumn(selCols[colIdx]);
                InStatColumnInfo infoBuf = new InStatColumnInfo();
                ret.add(infoBuf);
                ColumnDisplayDefinition colDef = null;
                if (col instanceof ExtTableColumn) {
                    colDef = ((ExtTableColumn)col).getColumnDisplayDefinition();
                    infoBuf.setColDef(colDef);
                }
                StringBuffer buf = new StringBuffer();
                int lastLength = buf.length();
                buf.append("(");
                for (int rowIdx = 0; rowIdx < nbrSelRows; ++rowIdx) {
                    if (0 < rowIdx) {
                        buf.append(",");
                        if (100 < buf.length() - lastLength) {
                            lastLength = buf.length();
                            buf.append("\n");
                        }
                    }
                    Object cellObj = this._table.getValueAt(selRows[rowIdx], selCols[colIdx]);
                    buf.append(this.getData(colDef, cellObj, TableCopySqlPartCommandBase.StatType.IN));
                }
                buf.append(")");
                infoBuf.setInstat(buf);
            }
        }
        return ret;
    }
}

